/* ******************************************************* */
/* filename Color.java
 * description provides the lgrammar program with colors
 */

package lgrammar;

import java.awt.*;

public class Colors extends Panel{
	public final static int COLOR_NUM = 16;
	public static final int DEF = 0,
				GREEN = 1,
				GREY = 2,
				OWN = 3;
	private int  	actual_copy = DEF,
			actual_store = DEF;
	private boolean individual = false;
	private Button[] but1 = new Button[COLOR_NUM],
			but2 = new Button[COLOR_NUM];
	private Button  b_def = new Button("Def"),
			b_green = new Button("Green"),
			b_grey = new Button("grey"),
			b_accept = new Button("Accept");
	private Label   l_def = new Label("Default Color Order  #"),
			l_own = new Label("Own Color Order");
	private Color choosen = new Color(255, 255, 255);
	private Color[]	def    = new Color[COLOR_NUM], 
			green  = new Color[COLOR_NUM],
			grey   = new Color[COLOR_NUM],
			 own   = new Color[COLOR_NUM];

	// constructor

	public Colors(){
		super();
		init_def();
		init_green();
		init_grey();
		init_own();
		init_lab(but1, def);
		init_lab(but2, own);
	}

	// instance methods

	public void init() {
		int i=0; // loop variable
		Panel 	p_buttons = new Panel(),
			palette1 = new Panel(),
			palette2 = new Panel();
		
		p_buttons.setLayout(new  FlowLayout());
		palette1.setLayout(new GridLayout(2, COLOR_NUM/2));
		palette2.setLayout(new GridLayout(2, COLOR_NUM/2));

		p_buttons.add(b_def);
		p_buttons.add(b_green);
		p_buttons.add(b_grey);
		p_buttons.add(b_accept);
		
		setLayout(new GridLayout(5, 1));
		for (i=0; i<COLOR_NUM; i++){
		   palette1.add(but1[i]);
		}
		for (i=0; i<COLOR_NUM; i++){
		  palette2.add(but2[i]);
		}
		add(l_def);
		add(palette1);
		add(l_own);
		add(palette2);
		add(p_buttons);
		repaint();
	} // end init()

	// initalize a label palette
	private void init_lab(Button[] lab, Color[] c){
		int i=0;
		for (i=0; i<COLOR_NUM; i++){
			lab[i] = new Button(" ");
			lab[i].setBackground(c[i]);
			
		}
	}
	private void set_lab(Button[] lab, Color[] c){
		int i=0;
		for(i=0; i<COLOR_NUM; i++){
			lab[i].setBackground(c[i]);
						
		}
	}

	// initilization of palettes

	private void init_def() {
		def[0] = new Color(0, 0, 0); //black 
		def[1] = new Color(100, 50, 0);   // brown
		def[2] = new Color(150, 140, 80); // brown-green
		def[3] = new Color(30, 100, 30);  // dark green
		def[4] = new Color(0, 255, 0);    // green
		def[5] = new Color(255, 255, 0);  // yellow
		def[6] = new Color(255, 140, 0);  // orange
		def[7] = new Color(255, 70, 0);   // orange red
		def[8] = new Color(255, 0, 0);    // red
		def[9] = new Color(200, 0, 140);  // pink
		def[10] = new Color(130, 0, 130); // violett
		def[11] = new Color(80, 0, 150);  // some kind of blue
		def[12] = new Color(0, 0, 255);   // blue
		def[13] = new Color(0, 200, 200); // tukis
		def[14] = new Color(100, 100, 100);// grey
		def[15] = new Color(255, 255, 255);// white
	}

	private void init_own() {
		int i=0;
		for (i=0; i<COLOR_NUM; i++){
		  own[i] =  new Color(255, 255, 255);
		}
	}

	private void init_green() {
		int i=0;
		int r, g, b, k = 0;
		for (i=0; i<COLOR_NUM/2; i++){
			k = 255/100;
			r = k*(50-3*i);
			g = k*(25+2*i);
			b = i;
			green[i] =  new Color(r, g, b);
		}
		for(i=COLOR_NUM/2; i<COLOR_NUM; i++){
			k = i* 255/COLOR_NUM;
			r = k/5;
			g = k;
			b = 20;
			green[i] = new Color(r, g, b);
		}
	}

	private void init_grey(){
		int i=0,
		    k=0;
		for (i=0; i<COLOR_NUM; i++){
		k = i*(255/COLOR_NUM);
		grey[i] =  new Color(k, k, k);
		}
	}

	// generell instance methods
	public boolean handleEvent (Event e) {
		int i =0;
		for (i=0; i<COLOR_NUM; i++){
		   if (e.target == but1[i]){ // simulates the cut mechnism
			switch (actual_copy){
			  case DEF: choosen = def[i]; break;
			  case GREEN : choosen = green[i]; break;
			  case GREY  : choosen = grey[i]; break;
			  default: ;
			}// end switch
			return true;
		   } // end if
		   if (e.target == but2[i]){ // paste mechanism
			but2[i].setBackground(choosen);
			own[i] = choosen;
			return true;
		   } // end if
		}
		if(e.target == b_def){
			set_lab(but1, def);
			set_curr(DEF);
			b_def.disable();
			return true;
		}
		if(e.target == b_grey){
			set_lab(but1, grey);
			set_curr(GREY);
			b_grey.disable();
			return true;
		}
		if(e.target == b_green){
			set_lab(but1, green);
			set_curr(GREEN);
			b_green.disable();
			return true;
		}
		if(e.target == b_accept){
			individual = true;
			actual_store = OWN;
			l_own.setText("Own Color Order       #");
			l_def.setText("Default Color Order");
			b_accept.disable();
			b_def.enable();
			b_grey.enable();
			b_green.enable();
			return true;
		}
		return false;
	}

	private void set_curr(int type) {
	// sets the current Color Palette
		individual = false;
		actual_store = type;
		actual_copy = type;
		l_own.setText("Own Color Order");
		l_def.setText("Default Color Order   #");
		b_green.enable();
		b_def.enable();
		b_grey.enable();
		b_accept.enable();
	}
	/* ************************************************* */

	//  TO COMUNICATE WITH OTHER CLASSES

	public Color[] get_Color(){
		if (individual) {return own;}
		else { 
	  	  switch (actual_store){
		 	case DEF: return def;
			case GREEN: return green;
			case GREY: return grey;
			default: ;
		  }
		 }
		return def; // to satisfy the compiler 	
	}
	public int get_palettetype(){
		return actual_store;
	}
	
	public void set_Color(int type){
	  // set_Color sets the Color Palette to the indicated type
	  // when a grammar is read from a file, if type isn't in [0..2]
	  // the default Palette is choosen. 
		switch (type) {
			case GREEN:
			  set_lab(but1, green);
			  set_curr(GREEN);
			  b_green.disable();
			  break;
			case GREY:
			   set_lab(but1, grey);
			   set_curr(GREY);
			   b_grey.disable();
			   break;
			default : 
			   set_lab(but1, def);
			   set_curr(DEF);
			   b_def.disable();
		} // end switch
	}

	public void set_Color(Color[] color){
	// set_Color sets the own_palette to the given color palette
		int i = 0;
		individual = true;
		actual_store = OWN;
		actual_copy = OWN;
		l_own.setText("Own Color Order       #");
		l_def.setText("Default Color Order");
		b_accept.disable();
		b_def.enable();
		b_grey.enable();
		b_green.enable();
		if(own[1] == null){
		   init_own();
		   init_def();
		}
		for(i=0; i < COLOR_NUM; i++){ 
		    but2[i].setBackground(color[i]);
		    own[i] = color[i];
		}
	}
}
/* **************************************************** */
/* class ColorWin 
 * description the Colors should be visible
 */ 

class ColorWin extends Frame{
	private Button b_ok = new Button("OK");
	private Colors colors = null;

	
	public ColorWin(Colors c){
		super("Colortable");
		colors = c;
	}

	public void init(){
		setLayout(new BorderLayout());
		colors.init();
		setFont(Xui.lgrammarFont);
		add("North", colors);
		add("South", b_ok);
	}

	public boolean action(Event e, Object o){
		if("OK".equals(o)){
			this.hide();
			return true;
		}
		else return false;
	}
}


