/* ************************************************ */
/* filename 	Draw.java
 * classes in Draw2.java Draw2, Turtle2, Turtle2_Stack, Trigonom
 */

package lgrammar;

import java.awt.*;

/* ************************************************ */
/* class Draw2
 * description controlls the turtle, that means translate the 
 * string into turtle comands
 */

class Draw2{

	Canvas mycanvas;
	Color[] color;
	
	Turtle2Stack stack = new Turtle2Stack(); 
	String grammar;
	int word_pos = 0; // the current position in word

	Turtle2  turtle, // the Turtle2 that runs
		start;  // the Turtle2 to remember the first position ..

	// constructores
	
	public Draw2(String grammar, Canvas c, Color[] color, Turtle2 turtle){
		this.grammar = grammar;
		this.mycanvas = c;
		this.color = color;
		this.start = turtle;
	}

	// instance methods	

	
	public void repaint(){
		paint(mycanvas.getGraphics());
	}
		 
	public void paint(Graphics g){

	int colorindex = 0;

	turtle = new Turtle2(start);

	 char [] gram = grammar.toCharArray();
	 double zeta;
	 int i = 0, // to go through the string
	     help = 0,
	    length = grammar.length();

	 char c; // help variable
	 StringBuffer sb = new StringBuffer();
	 String str;

		
	// set the draw color
	g.setColor(color[0]);

	// draw the string
	turtle.inc_depth();	
	while(i < length) {
	   if(i == word_pos) turtle.dec_depth();
	   c = gram[i];
	   switch(c) {
		case 'F' : if((i+3 < length) && (gram[i+1] == '<')) {
				// if F has an indice
				if (Character.isDigit(gram[i+2])){
					i += 2;
					// convert the folowing into a Integer
					while(gram[i] != '>') {
						sb.append(gram[i]);
						i++;
					}
					str = new String(sb);
					try {
					   help = Integer.parseInt(str);
					} catch(NumberFormatException e){
					   help = 1;
					}
					sb = new StringBuffer(); 
					// clean it for later operations
				    	turtle.go(g, help);
				} // end if(Character.isDigit(gram[i+2]))
				else {
				  if ((i+6 < length) && (gram[i+4] == '<')) {
				  // F has an appendix and a indice	
					i = i+5; // ignore appendix
					while(gram[i] != '>') {
					 // convert the folloowing into an Integer
					 sb.append(gram[i]);
					 i++;
					} // end while
					str = new String(sb);
					try {
					    help = Integer.parseInt(str);
					} catch(NumberFormatException e) {
					   help = 1;
					}
					sb = new StringBuffer(); // clean it for later operations
					turtle.go(g, help);
				  } // end if((i+6 < length) && ...)
				  else{
					// no appendice and this stuff
					turtle.go(g);
				} // end else
				} // end else 
			} // end if((i+3 < length) && (gram[i+1] == '<'))
			else { 
			// no appendice and this stuff
				turtle.go(g);
			}
			break;
		case 'f' :if((i+3 < length) && (gram[i+1] == '<')) {
				// if F has an indice
				if (Character.isDigit(gram[i+2])){
					i += 2;
					// convert the folowing into a Integer
					while(gram[i] != '>') {
						sb.append(gram[i]);
						i++;
					}
					str = new String(sb);
					try {
					   help = Integer.parseInt(str);
					} catch (NumberFormatException e) {
					  help = 1;
					}
					sb = new StringBuffer(); // clean it for later operations
				    	turtle.jump(help);
				} // end if(Character.isDigit(gram[i+2]))
				else {
				  if ((i+6 < length) && (gram[i+4] == '<')) {
				  // F has an appendix and a indice	
					i = i+5; // ignore appendix
					while(gram[i] != '>') {
					 // convert the following into an Integer
					 sb.append(gram[i]);
					 i++;
					} // end while
					str = new String(sb);
					try {
					  help = Integer.parseInt(str);
					} catch (NumberFormatException e) {
					  help = 1;
					}
					sb = new StringBuffer(); // clean it for later operations
					turtle.jump(help);
				  } // end if((i+6 < length) && ...)
				  else{
					// no appendice and this stuff
					turtle.jump();
				} // end else 
				} // end else 
			} // end if((i+3 < length) && (gram[i+1] == '<')) 
			else { 
			// no appendice and this stuff 
			  turtle.jump();
			}
			break;
		case '+' : if ((i+3 < length) && (gram[i+1] == '<')) {
				// appendix follows
				i +=2;
				while (gram[i] != '>') {
				    // convert the following into an Integer
					 sb.append(gram[i]);
					 i++;
				} // end while
				str = new String(sb);
				try {
				  zeta = Double.valueOf(str).doubleValue();
				  sb = new StringBuffer(); // clean it fpor later operations
				  turtle.rotate_left(zeta);
				} catch (NumberFormatException e) {
					turtle.rotate_left();
				}
			} // end if ((i+3 < length) && (gram[i+1] == '<')) 
			else {
				turtle.rotate_left();
			}	
			break;			 
		case '-' : if ((i+3 < length) && (gram[i+1] == '<')) {
				// appendix follows
				i +=2;
				while (gram[i] != '>') {
				    // convert the following into an Integer
					 sb.append(gram[i]);
					 i++;
				} // end while
				try{
				  str = new String(sb);
				  zeta = Double.valueOf(str).doubleValue();
				  sb = new StringBuffer(); // clean it fpor later operations
				  turtle.rotate_right(zeta);
				} catch(NumberFormatException e){
					turtle.rotate_right();
				}
			} // end if ((i+3 < length) && (gram[i+1] == '<')) 
			else {
			 turtle.rotate_right();
			}
			break;
		case '[' : stack.push(new Turtle2(turtle));
			turtle = new Turtle2(turtle);
			break;
		case ']' : turtle = stack.pop();
			break;
		case '|' : turtle.back();
			break;
		case '`' : // next color
			  colorindex++; 
			if (colorindex > Colors.COLOR_NUM-1) colorindex = 1;
			g.setColor(color[colorindex]);
			break;	
		case ''' : // previous Color
			if (colorindex > 0){
			 colorindex--;
			}
			else {
			 colorindex = Colors.COLOR_NUM - 1;
			}
			g.setColor(color[colorindex]);
			break;
		 
		default : ;
	   } // end switch
	   i++;
	 }  // end while
	 }
	/* ************************************************ */

	// PUBLIC METHODS TO COMUNICATE WITH OTHER CLASSES

	public void clear(){
		Graphics g =mycanvas. getGraphics();		
		Dimension d = mycanvas.size();
		g.setColor(mycanvas.getBackground());
		g.clearRect(0, 0, d.width, d.height);
	} 

	public void draw_next(String str){
		grammar = str;
		start.inc_depth();
		repaint();	
		word_pos = 0;
	}

	public void draw_prev(String str){
		grammar = str;
		start.dec_depth();
		repaint();
	}

	public void draw_single(String str, int position){
		grammar = str;
		word_pos = position;
		if (word_pos == 0) start.inc_depth();
		// if you reach the end of word with single derivations!!
		repaint();
		word_pos = 0; // to clean the variable for further operations
	}

}

/* ************************************************ */
/* class Turtle2
 *
 */

class Turtle2 {
	Vector2 pos; // actual position
	Vector2 head, // the inputed head vector
		h_head; // the current head vector
	double  angle, //the rotate standard angle
	        scale, // minimisation of F or f
		angle_sum = 0.0; // current sum of angel  
	int length; // length in pixel for F or f 
	int depth = 0;
	static final Trigonom trigonom = new Trigonom(); 
	// constructores

	public Turtle2 (Vector2 pos,  Vector2 head, double angle, 
			double scale, int length) {
		this.pos = new Vector2(pos.x, pos.y, false);
		this.head = new Vector2(head.x, head.y, false);
		this.h_head = new Vector2(head.x, head.y, false);
		this.angle = angle;
		this.scale = scale;
		this.length = length;
		
	}

	public Turtle2 (Turtle2 t) {
		pos = new Vector2(t.pos.x, t.pos.y, false);
		head = new Vector2(t.head.x, t.head.y, false);
		h_head = new Vector2(t.h_head.x, t.h_head.y, true);
		this.angle = t.angle;
		this.scale = t.scale;
		this.length = t.length;
		this.depth = t.depth;
		this.angle_sum = t.angle_sum;
	}

	// instance methods
	
	public void inc_depth(){
		this.depth++;
	}	

	public void dec_depth() {
		this.depth--;
	}
/* ***************************************************** */
/*  		  	G O 				 */
/* ***************************************************** */

	public void go(Graphics g) {
		go(g, 1);
	}

	public void go(Graphics g, int factor){
		double f = Math.pow(scale, -(depth)) * length * factor;
		int xend, yend;
		int xstart = (int)pos.x;
		int ystart = (int)pos.y;
		pos.x = pos.x + h_head.x * f;
		pos.y = pos.y + h_head.y * f;
		xend = (int)(pos.x);
		yend = (int)(pos.y);
		g.drawLine(xstart, ystart, xend, yend);
		
	}

/* ***************************************************** */
/*  		  B A C K				 */
/* ***************************************************** */
	
	public void back() {
		Vector2 help = new Vector2(-h_head.x, -h_head.y, true);
		h_head = help;
	}
/* ***************************************************** */
/*  		  	 R O T A T E 			 */
/* ***************************************************** */

	public void rotate_left(){
		rotate(-angle);
	}

	public void rotate_left(double arg){
		rotate(-arg);
	}

	public void rotate_right(){
		rotate(angle);
	}

	public void rotate_right(double arg){
		rotate(arg);
	}

	private void rotate(double arg) {
		
		double sin_theta, cos_theta;
		double theta;
	
		angle_sum += arg;
		while (angle_sum < 0) { angle_sum = 360 + angle_sum;}
		while (angle_sum > 360) {angle_sum = angle_sum - 360;}

		if(angle_sum - (int)(angle_sum) == 0){
			sin_theta = trigonom.sin[(int)(angle_sum)];
			cos_theta = trigonom.cos[(int)(angle_sum)];
		} else { 
		theta = angle_sum * Math.PI / 180;
		sin_theta = Math.sin(theta);
		cos_theta = Math.cos(theta);
		}
		
		h_head.x =  head.x * cos_theta - head.y * sin_theta;
		h_head.y =  head.x * sin_theta + head.y * cos_theta;

		
	}
/* ***************************************************** */
/*  		  	J U M P 			 */
/* ***************************************************** */

	public void jump() {
		jump(1);
	}

	public void jump(int factor){
		double f = Math.pow(scale, -(depth)) * length * factor;
		pos.x = pos.x + f*h_head.x;
		pos.y = pos.y + f*h_head.y;
	}

}



/* ***************************************************** */
/* class Vector2
 * similar to point but double  instead of integers
 */

class Vector2{
	public double  	x,
			y;
	// constructor
	public Vector2(double x, double y, boolean normalize){
		double abs;
		if (normalize){
		abs = Math.sqrt(x*x + y*y); // vector has length = 1.0 !!
		this.x = x/abs;
		this.y = y/abs;
	} else {
		this.x = x;
		this.y = y;
	}
	}
}

/* ***************************************************** */
/* class Turtle2Stack
 */

class Turtle2Stack{
	static final int MAX = 50;
	Turtle2[] stack = new Turtle2[MAX];
	int index = 0; 

	// constructores

	public Turtle2Stack(){
	 	super();
	}

	// instance methods
	public Turtle2 pop() {
		Turtle2 turtle;
		index--;
		turtle = stack[index];
		stack[index] = null;
		return turtle;
	}
	public void push(Turtle2 turtle){
		stack[index] = turtle;
		index++;
	}
}

/* ***************************************************** */
/* class Trigonom
 */

class Trigonom{
	public double[] sin = new double[361];
	public double[] cos = new double[361];
	
	public Trigonom() {
		int i = 0;
		double psi;
		for (i=0;  i<361; i++){
		  psi = i * Math.PI / 180;
		  sin[i] = Math.sin(psi);
		  cos[i] = Math.cos(psi);
		}
		sin[0]   =  0.0; sin[180] =  0.0;
		sin[30]  =  0.5; sin[210] = -0.5;
		sin[90]  =  1.0; sin[270] = -1.0;
		sin[150] =  0.5; sin[330] = -0.5;
		sin[360] =  0.0;

		cos[0]   =  1.0; cos[180] = -1.0;
		cos[60]  =  0.5; cos[240] = -0.5;
		cos[90]  =  0.0; cos[270] =  0.0;
		cos[120] = -0.5; cos[300] =  0.5;
		cos[360] =  1.0;
		}

}



