/* ******************************************** */
/* Fileaname Draw3.java
 * Classes in Draw3.java Draw3, Turtle3, Turtle3Stack
 */

package lgrammar;

import java.awt.*;

/* ********************************************** */
/* class Draw3
 * description controlls a 3D-Turtle, it translates the
 * grammar-string into turtle comands
 */

class Draw3 {
	Canvas mycanvas;
	Color[] color;
	
	Turtle3Stack stack = new Turtle3Stack();
	String grammar;
	int word_pos = 0;


	Turtle3 turtle, // turtle that draws
		start; // turtle to remember the configuration at the beginning

	// constructores

	public Draw3(String grammar, Canvas canvas, Color[] color, 
			Turtle3 turtle){
		this.grammar = grammar;
		this.mycanvas = canvas;
		this.color = color;
		this.start = turtle;
	}

	public void repaint() {
		paint(mycanvas.getGraphics());
	}

	public void paint(Graphics g){
		int  	colorindex = 0, 
			i = 0,		//to go through the grammar
			help = 0 ,	// various functions
			length = grammar.length(); // length of grammar
		char[] gram = grammar.toCharArray();
		double zeta;		 // for convertions
		char c; 		// current character in String
		StringBuffer sb = new StringBuffer(); // for convertions
		String str; // for convertions

		turtle = new Turtle3(start);
		
		// set draw color
		g.setColor(color[0]);

		// draw the string
		turtle.inc_depth();
		while(i < length){
		   if (i == word_pos) turtle.dec_depth();
		   c = gram[i];
		   switch(c){
			case 'f': // jump
			case 'F': // draw a line
			   if((i+3 < length) && (gram[i+1] == '<')) {
				// if F has an indice
				if (Character.isDigit(gram[i+2])){
					i += 2;
					// convert the folowing into a Integer
					while(gram[i] != '>') {
						sb.append(gram[i]);
						i++;
					}
					str = new String(sb);
					try{
					  help = Integer.parseInt(str);
					} catch(NumberFormatException e) {
					  help = 1;
					}
					sb = new StringBuffer(); 
					// clean it for later operations
					if (c=='f') {
				   	  turtle.jump(help);
					} else {     	
					  turtle.go(g, help);
					}
				} // end if(Character.isDigit(gram[i+2]))
				else {
				  if ((i+6 < length) && (gram[i+4] == '<')) {
				  // F has an appendix and a indice	
					i = i+5; // ignore appendix
					while(gram[i] != '>') {
					 // convert the folloowing into an Integer
					 sb.append(gram[i]);
					 i++;
					} // end while
					str = new String(sb);
					try{
					  help = Integer.parseInt(str);
					} catch(NumberFormatException e) {
					  help = 1;
					}
					sb = new StringBuffer(); 
					// clean it for later operations
					if (c == 'f'){
					  turtle.jump(help);
					} else {
					  turtle.go(g, help);
					}
				  } // end if((i+6 < length) && ...)
				else{
				  // no appendice and this stuff
				  if(c == 'f') {
				  	turtle.jump();
				  } else{
					turtle.go(g);
				  }
				}// end else
				} // end else 
			} // end if((i+3 < length) && (gram[i+1] == '<'))
			else { 
			// no appendice and this stuff
				if(c == 'f') {
				  turtle.jump();
				} else{
				turtle.go(g);
				}
			}
			break;
		case '-' : // turtle rotate left/right
		case '+' : if((i+3 < length) && (gram[i+1] == '<')) {
				// appendix follows
				i +=2;
				while (gram[i] != '>') {
				    // convert the following into an Integer
					 sb.append(gram[i]);
					 i++;
				} // end while
				try {
				  str = new String(sb);
				  zeta = Double.valueOf(str).doubleValue();
				  sb = new StringBuffer(); 
				  // clean it for later operations
				  if(c=='-'){
				     turtle.rotate_right(zeta);
				  } else{
				    turtle.rotate_left(zeta);
				  } 
				} catch (NumberFormatException e){
				   if(c=='-'){
				     	turtle.rotate_right();
				   } else{
					turtle.rotate_left();
				   }
				} // end try/catch	  
			} // end if ((i+3 < length) && (gram[i+1] == '<')) 
			else {
				if(c=='-'){
				turtle.rotate_right();
				} else{
				turtle.rotate_left();
				}
			}	
			break;
		case '^' :
		case '&' : if((i+3 < length) && (gram[i+1] == '<')) {
				// appendix follows
				i +=2;
				while (gram[i] != '>') {
				    // convert the following into an Integer
					 sb.append(gram[i]);
					 i++;
				} // end while
				try {
				  str = new String(sb);
				  zeta = Double.valueOf(str).doubleValue();
				  sb = new StringBuffer(); 
				  // clean it for later operations
				  if(c=='~'){
				    turtle.rotate_up(zeta);
				  } else{
			 	    turtle.rotate_down(zeta);
				  }
				} catch(NumberFormatException e) {
				   if(c=='~'){
				     turtle.rotate_up();
				   } else{
				     turtle.rotate_down();
				   }
				} // end try/catch 
			} // end if ((i+3 < length) && (gram[i+1] == '<')) 
			else {
				if(c=='~'){
				turtle.rotate_up();
				} else{
				turtle.rotate_down();
				}
			}	 
			break;
		case '/' :
		case 92  : //  ascii number for  \
			if((i+3 < length) && (gram[i+1] == '<')) {
				// appendix follows
				i +=2;
				while (gram[i] != '>') {
				    // convert the following into an Integer
					 sb.append(gram[i]);
					 i++;
				} // end while
				try{
				  str = new String(sb);
				  zeta = Double.valueOf(str).doubleValue();
				  sb = new StringBuffer(); 
				  // clean it for later operations
				  if(c=='/'){
				     turtle.rotate_rightu(zeta);
				  } else{
				    turtle.rotate_leftd(zeta);
				  } 
				} catch(NumberFormatException e) {
				   if(c=='/'){
				     turtle.rotate_rightu();
				   } else{
				     turtle.rotate_leftd();
				   }
				} // end try/catch 
			} // end if ((i+3 < length) && (gram[i+1] == '<')) 
			else {
				if(c=='/'){
				turtle.rotate_rightu();
				} else{
				turtle.rotate_leftd();
				}
			}	 
			break;
		case '|' : turtle.back();
			break;
		case '$' : // turtle rotate to vertical
			turtle.rotate_ver();
			break;
		case '[' : // start a branch
 			stack.push(new Turtle3(turtle));
			turtle = new Turtle3(turtle);
			break;
		case ']' :turtle = stack.pop();
			break;
		
		case '`' : // next color
			  colorindex++; 
			if (colorindex > Colors.COLOR_NUM-1) colorindex = 1;
			g.setColor(color[colorindex]);
			break;	
		case ''' : // previous Color
			if (colorindex > 0){
			 colorindex--;
			} else {
			 colorindex = Colors.COLOR_NUM - 1;
			}
			g.setColor(color[colorindex]);
			break;
		case '{' : // start a polygon
			turtle.new_poly();
			break;
		case '}' : // end of polygon
			turtle.fill_poly(g);
			break;
		case '.' : // next vertex
			turtle.add_vertex();
			break;
		case 'G' : // go in polygon
			if((i+3 < length) && (gram[i+1] == '<')) {
				// appendix follows
				i +=2;
				while (gram[i] != '>') {
				    // convert the following into an Integer
					 sb.append(gram[i]);
					 i++;
				} // end while
				str = new String(sb);
				help = Integer.parseInt(str);
				sb = new StringBuffer(); // clean it fpor later operations
				turtle.go_in_poly(help);
		} // end if ((i+3 < length) && (gram[i+1] == '<')) 
			else {
			  turtle.go_in_poly();
			}	
			break;
		default :;
	  } // end switch
	i++;
	} // end while
}	

	/* ************************************************* */

	// COMUNICATION WITH OTHER CLASSES

	public void  clear() {
		Graphics g = mycanvas.getGraphics();
		Dimension d = mycanvas.size();
		g.clearRect(0, 0, d.width, d.height);
	}
	public void draw_next(String str){
		grammar = str;
		start.inc_depth();
		repaint();
	}
	public void draw_prev(String str){
		grammar = str;
		start.dec_depth();
		repaint();
	}
	public void draw_single(String str, int position){
		grammar = str;
		word_pos = position;
		if (word_pos == 0) start.inc_depth();
		// if the end of word is reached by single derivations
		repaint();
		word_pos = 0;
	}

}

/* ************************************************ */
/* class Turtle3
 *
 */

class Turtle3 {
	static final Trigonom trigonom = new Trigonom();
	static Projection proj = null; 
	Vector3 pos, 		// the current position
		head,    	// heading-vector 
		head_up,   	// up-vector
		head_left; 	// left-vector
	double  angle,		// angle for rotation
		scale;		// minimisation for F or f
	int length,		// length in pixel for F or f
	    depth = 0; 		// depth of derivation	
	static Polygon polygon = null;

	/* ************************************************ */
	/* 		C O N S T R U C T O R E S	    */
	/* ************************************************ */

	public Turtle3 (Projection proj, Vector3 pos,  Vector3 head, 
			Vector3 head_up, Vector3 head_left, 
			double angle, double scale,
			int length){
		this.proj = proj;
		this.pos = pos;
		this.head = head;
		this.head_up = head_up;
		this.head_left = head_left;
		this.angle = angle;
		this.scale = scale;
		this.length = length;
	}

	public Turtle3 (Turtle3 t){
		this.head = new Vector3(t.head.x, t.head.y, t.head.z);
		this.pos = new Vector3(t.pos.x, t.pos.y, t.pos.z);
		this.head_up = new Vector3(t.head_up.x, t.head_up.y, 
						t.head_up.z);
		this.head_left = new Vector3(t.head_left.x, t.head_left.y,
						t.head_left.z);
		this.angle = t.angle;
		this.scale = t.scale;
		this.length = t.length;
		this.depth = t.depth;
	}

	/* ************************************************ */
	/* 		INSTANCE METHODS		    */
	/* ************************************************ */

	// CHANGE THE DEPTH

	public void inc_depth(){
		this.depth++;
	}	

	public void dec_depth() {
		this.depth--;
	}

	/* ************************************************ */

	// TURTLE GO

	public void go(Graphics g) {
		go(g, 1);
	}	
	public void go(Graphics g, int factor){
		double f = Math.pow(scale, -(depth)) * length * factor;
		Vector3 nextpoint = new Vector3(pos.x + f*head.x,
						pos.y + f*head.y,
						pos.z + f*head.z);
		Point start, end;
			start = proj.persp(pos);
			end   = proj.persp(nextpoint);
			g.drawLine(start.x, start.y, end.x, end.y);
			pos = new Vector3(nextpoint.x, nextpoint.y, 
				nextpoint.z);
	
	}

	/* ************************************************ */

	// TURTLE JUMP

	public void jump(){
		jump(1);
	}

	public void jump(int factor) {
		Point position = null;
		double f = Math.pow(scale, -(depth)) * length * factor;

		Vector3 nextpoint = new Vector3(pos.x + f*head.x,
						pos.y + f*head.y,
						pos.z + f*head.z);
		pos = nextpoint;
		if(polygon != null){
		// f is between '{' and '}' ...
			position = proj.persp(pos);
			polygon.addPoint(position.x, position.y);
		}
	}

	/* ************************************************ */

	// TURTLE ROTATE

	// ROTATE LEFT/RIGHT
	public void rotate_left(){
		rotate_left(angle);
	}
	public void rotate_right(){
		rotate_left(-angle);
	}
	public void rotate_right(double arg){
		rotate_left(-arg);
	}
	public void rotate_left(double arg){
		double theta, sin_theta, cos_theta;
		Vector3 hhelp, lhelp;
		while (arg < 0) { arg += 360;}
		while (arg > 360) { arg -= 360;}
		if (arg == (int)(arg)) {
			sin_theta = trigonom.sin[(int)(arg)];
			cos_theta = trigonom.cos[(int)(arg)];
		} else {
			theta = arg * Math.PI/ 180;
			sin_theta = Math.sin(theta);
			cos_theta = Math.cos(theta);
		}
		hhelp = new Vector3(head.x*cos_theta + head_left.x*sin_theta,
				    head.y*cos_theta + head_left.y*sin_theta,
				    head.z*cos_theta + head_left.z*sin_theta);
		lhelp = new Vector3(-head.x*sin_theta + head_left.x*cos_theta,
				    -head.y*sin_theta + head_left.y*cos_theta,
				    -head.z*sin_theta + head_left.z*cos_theta);
		head_left = lhelp;
		head = hhelp;
	}

	// ROTATE UP/DOWN

	public void rotate_down(){
		rotate_up(-angle);
	}
	public void rotate_down(double arg){
		rotate_up(-arg);
	}
	public void rotate_up(){
		rotate_up(angle);
	}
	public void rotate_up(double arg){
		double theta, sin_theta, cos_theta;
		Vector3 hhelp, uhelp;
		while (arg < 0) { arg += 360;}
		while (arg > 360) { arg -= 360;}
		if (arg == (int)(arg)) {
			sin_theta = trigonom.sin[(int)(arg)];
			cos_theta = trigonom.cos[(int)(arg)];
		} else {
			theta = arg * Math.PI/ 180;
			sin_theta = Math.sin(theta);
			cos_theta = Math.cos(theta);
		}
		hhelp = new Vector3(head.x*cos_theta + head_up.x*sin_theta,
				    head.y*cos_theta + head_up.y*sin_theta,
				    head.z*cos_theta + head_up.z*sin_theta);
		uhelp = new Vector3(-head.x*sin_theta + head_up.x*cos_theta,
				    -head.y*sin_theta + head_up.y*cos_theta,
				    -head.z*sin_theta + head_up.z*cos_theta);
		head = hhelp;
		head_up = uhelp;
	}
	
	// ROTATE DOWN-LEFT / UP-RIGHT

	public void rotate_leftd(){
		rotate_leftd(angle);
	}
	public void rotate_rightu(){
		rotate_leftd(-angle);
	}
	public void rotate_rightu(double arg){
		rotate_leftd(-arg);
	}
	public void rotate_leftd(double arg) {
		double theta, sin_theta, cos_theta;
		Vector3 uhelp, lhelp;
		while (arg < 0) { arg += 360;}
		while (arg > 360) { arg -= 360;}
		if (arg == (int)(arg)) {
			sin_theta = trigonom.sin[(int)(arg)];
			cos_theta = trigonom.cos[(int)(arg)];
		} else {
			theta = arg * Math.PI/ 180;
			sin_theta = Math.sin(theta);
			cos_theta = Math.cos(theta);
		}
		lhelp=new Vector3(head_left.x*cos_theta - head_up.x*sin_theta,
				head_left.y*cos_theta - head_up.y*sin_theta,
				head_left.z*cos_theta - head_up.z*sin_theta);
		uhelp=new Vector3(head_left.x*sin_theta + head_up.x*cos_theta,
				head_left.y*sin_theta + head_up.y*cos_theta,
				head_left.z*sin_theta + head_up.z*cos_theta);
		head_left = lhelp;
		head_up = uhelp;
	}

	/* ************************************************ */

	// TURTLE TURN AROUND

	public void back(){
		head = new Vector3(-head.x, -head.y, -head.z);
		head_left = new Vector3(-head_left.x,
					-head_left.y,
					-head_left.z);
	} 

	// TURTLE RETURN TO VERTICAL

	public void rotate_ver(){
		double abs = 0.0;
	 	if((head.x != 0) || (head.z != 0)){
			abs = 1/(Math.sqrt(head.x*head.x + head.y*head.y 
					+ head.z*head.z));
			head_left.x = head.z/abs;
			head_left.y = 0;
			head_left.z = -head.z/abs;
			head_up.x = -head.x*head.y;
			head_up.y = head.x*head.x + head.z*head.z;
			head_up.z = -head.y*head.z;
		}
	}

	/* ************************************************ */

	// POLYGON STUFF

	public void new_poly(){
		int [] xpoints = new int[1];
		int [] ypoints = new int[1];
		Point position = proj.persp(pos);
		xpoints[0] = position.x;
		ypoints[0] = position.y; 
		polygon = new Polygon(xpoints, ypoints, 1);
		}

	public void add_vertex(){
		if(polygon == null){
			polygon = new Polygon();
		}
		Point position = proj.persp(pos);
		polygon.addPoint(position.x, position.y);
	}
	
	public void go_in_poly(){
		go_in_poly(1);
	}
	public void go_in_poly(int factor){
		double f = Math.pow(scale, -(depth)) * length * factor;
		Vector3 nextpoint = new Vector3(pos.x + f*head.x,
						pos.y + f*head.y,
						pos.z + f*head.z);
		pos = nextpoint;
	}
	
	public void fill_poly(Graphics g){
		g.fillPolygon(polygon);
		polygon = null;
	}
}
/* ************************************************ */
/* class Vector3
 *
 */

class Vector3{
	public double   x,
			y,
			z;

	// constructor
	public Vector3(double x, double y, double z){
		this.x = x;
		this.y = y;
		this.z = z;
	}

	// instance method
	public void norm(){
		double abs = Math.sqrt(x*x + y*y + z*z);
		x=x/abs;
		y=y/abs;
		z=z/abs;
	}
}

/* ***************************************************** */
/* class Turtle3Stack
 */

class Turtle3Stack{
	static final int MAX = 20;
	Turtle3[] stack = new Turtle3[MAX];
	int index = 0; 

	// constructores

	public Turtle3Stack(){
	 	super();
	}

	// instance methods
	public Turtle3 pop() {
		index--;
		return stack[index];
	}
	public void push(Turtle3 turtle){
		stack[index] = turtle;
		index++;
	}
}






