/* filename 	Grammar.java
 * classes in Grammar.java  Grammar, Symbol, GrammarInitFailedException
*/

package lgrammar;

import java.lang.Math;
import java.util.Vector;
import java.lang.Double;
import java.lang.Character;

public class Grammar {
	// constants
	public final int 	MAXSYMBOLS = 50,
				MAXDERIVES = 20;
	private int symb_number = 0; // the number of all derivable symbols
	private Symbol[] derivables = new Symbol[MAXSYMBOLS]; // includes all
							// derivable Symbols
							// of this grammar
	private String[] old_words = new String[MAXDERIVES];// all words 
						// computed until yet
	private char[] leftsides = new char[100];
	private String 	grammar_str, // the input string
			 axiom = new String();// the axiom of this grammar
	private StringBuffer current_word = new StringBuffer(); // derived word
	public int dimen = 3,
		   derive_count = 0,
		   a_position = 0;//position in current_word isn't derived yet
/* *********************************************************** */
/*  		C O N S T R U C T O R S			       */	
/* *********************************************************** */	

public Grammar(String str) {
		this.grammar_str = str;
}
	
/* *********************************************************** */
/*  	  I N S T A N C E  M E T H O D S		       */
/* *********************************************************** */

/* *********************************************************** */
/*  methods for testing the correctness of the input grammar   */
/* *********************************************************** */

/* method test_and_init throws GrammarInitFailedException
 * calls all test methods and init method
 * arguments non
 * returns non
 */
public void test_and_init() throws GrammarInitFailedException{
	if(grammar_str.length() < 2) // empty grammar 
	 throw new GrammarInitFailedException(GrammarInitFailedException.e1);
	if (!test_parent())	
	 throw new GrammarInitFailedException(GrammarInitFailedException.e2);
	grammar_init();
	dimen = test_dimen();// dimen init
	if(!test_prob())
	 throw new GrammarInitFailedException(GrammarInitFailedException.e3);
	derive_count = 0;
	current_word = new StringBuffer(axiom);
}

/* ***************************************************** */
/* method test_parent
 * tests, whether the {,} [,] and <,> are corerct in the string
 * arguments String str, the input grammar
 * returns boolean, true iff the parenties are correct
 */
public boolean test_parent(){
	int 	i = 0,  		// index to go throught the string
		length = grammar_str.length(), // length of string
		r = 0, 			// to count the '[' and ']'
		s = 0, 			// to count the '{' and '}'
		t = 0; 			// to count the '<' and '>'
	char[] gram = grammar_str.toCharArray();

	while (i < length) {
	   switch(gram[i]){
		case '[': r++;
			  break;
		case ']': r--;
			  if (r<0) return false;
			  break;
		case '{': s++;
			  if (s>1) return false; 
			  break;
		case '}': s--;
			  if (s<0) return false;
			  break;
	 	case '<' : t++;
			   if (t>1) return true;
			  break;
		case '>' : t--;
			   if (t<0) return false;
			   break;
		case '\n' : // end of a line
			   if ((r!=0) || (s!=0) || (t!=0)) return false;
			   break;
		default : break; // ignore all other symbols
		} // end of switch
	  i++;
	} // end while
	return true; // grammar correct
}

/* ***************************************************** */
/* method test_prob
 * description test the probabilities
 * arguments non
 * returns true if all probabilities are correct
 */

public boolean test_prob(){
	int i= 0;
	boolean correct = true;
	while(i<symb_number){
		correct = ((derivables[i].test_prob()) && correct);
		i++;
	}
	return correct;
}

/* *********************************************************** */
/*  	methods for initialize the grammar  		       */
/* *********************************************************** */
/* method grammar_init
/* description 
/* arguments non
/* returns non
 */
private void grammar_init() throws GrammarInitFailedException{
	char[] gram = grammar_str.toCharArray();
	char 	a_name, // to initialize the symbols
		a_indice = ' ';
	double a_prob = 0.0;
	Symbol a_symb;
	int 	length = grammar_str.length(),
		i = 0 ; // index to go throught the grammar
	StringBuffer read_in = new StringBuffer();

	//read axiom
	while((gram[i] != '\n') && (i < length)){
		if (gram[i] != ' ') // ignore blanks
		  read_in.append(gram[i]);
	  	i++;
	}
	axiom = new String(read_in);
	read_in = new StringBuffer();
	// end read axiom
	i++; //ignore newline
	//read rules
	while(i < length){
		//read leftside of rule
		a_name = gram[i];
		i++;
		while(gram[i] == ' '){i++;}//ignore blanks
		if (gram[i] == '<'){
			i++;
			a_indice = gram[i];
			i = i+2;
		}
		else {a_indice = ' ';}
		if(exsists_symbol(a_name, a_indice)){
			a_symb = get_symbol(a_name, a_indice);}
		else{
			a_symb = new Symbol(a_name, a_indice);
			add_symbol(a_symb);
		}
		while(gram[i] == ' '){i++;}
		if (gram[i] != '=')
		  throw new GrammarInitFailedException(GrammarInitFailedException.e4);
		i++; // there must be a '='
		// read rightside of production
		while(gram[i] == ' '){i++;}
		if(gram[i] == '<') { // probability follows
			i++;
			while(gram[i] != '>'){
			  read_in.append(gram[i]);
			  i++;
			}// end while
			// StringBuffer to Double
			a_prob = Double.valueOf(new String(read_in)).doubleValue();
			read_in = new StringBuffer();
			i++;
		}
		else {a_prob = 1.0;}
		while((gram[i] != '\n') && (i < length)) {
			//read rightside in read_in ignores blanks
			if (gram[i] != ' ') read_in.append(gram[i]); 
			i++;
		} // end read rightside
		a_symb.add_rule(new String(read_in), a_prob);
		i++;
		read_in = new StringBuffer();
		} // end while (i<length)
}

/* ***************************************************** */
/* method test_dimen 
 * test, whether the input grammar is a 2D or a 3D grammar
 * arguments String grammar_str - the input grammar
 * returns 3, if the grammar includes 3d-Symbols, 2 otherwise
 */
	
private  int test_dimen(){
	String d3_string = new String("^&V${}G~!%");
	char[] d3_symbole = d3_string.toCharArray();
	int length = d3_string.length() ; // lenght of d3_symbole
	boolean d3 = false;
	int i = 0; // index

	while ((i < 9) && !d3){
		// while not all tested not d3-symbol found
		d3 = in_String(grammar_str, d3_symbole[i]);
		i++;
		}
	if (d3) return 3;
	return 2;
}

/* *********************************************** */
/* method in_String
 * helps the test_dimen method to find characters in a String
 */

private static boolean in_String(String str, char c){
	int 	i = 0, // index to go throught the grammar
		length = str.length(); // length of grammar
	boolean found = false;
	char [] str_array = str.toCharArray();   
	
	while(i < length){
 	 if (str_array[i] == c)
		found = true;
	 i++;
	}// end while
	return found;
}

/* *********************************************************** */
/*  	methods to handle with the Symbol stuff 	       */
/* *********************************************************** */

/* method get_symbol
 * description fetches an excisting Symbol from derivables
 * arguments name, indice
 * returns
 */
private Symbol get_symbol(char name, char indice){
	int i=0;
 	boolean found = false;
	while((i < symb_number) && (!found)){
		found = (derivables[i].name == name) && 
				(derivables[i].indice == indice);
		i++;
	}
	return derivables[i-1];
}

/* *********************************************************** */
/* method exsists_symbol
 * description testds if the symbol is in derivables
 * arguments
 */
private boolean exsists_symbol(char name, char indice) {
	int i=0;
 	boolean found = false;
	while((i < symb_number) && (!found)){
		found = (derivables[i].name == name) && 
				(derivables[i].indice == indice);
		i++;
	}
	return found;
}
/* *********************************************************** */
/* method add_symbol
 * description adds the symbol only if it isn't in derivables yet
 */
private void add_symbol(Symbol s) {
	if(! exsists_symbol(s.name, s.indice)){
		derivables[symb_number] = s;
		leftsides[symb_number]=s.name;
		symb_number++;
	}
}

/* *********************************************************** */
/*  			methods for derivation	 	       */
/* *********************************************************** */
/* method is_derivable
 *
 */
private boolean is_derivable(char name){
	int i=0;
	boolean found = false;
	while (i<symb_number){
		found = found || (leftsides[i] == name);
		i++;
	}
	return found;
}
/* *********************************************************** */
/* method derive_word
 * description derives the whole word and sets curent word
 *
 */
private void derive_word(){
	String insertion = new String();//for the rightsides 
	StringBuffer new_word = new StringBuffer();
	int i = 0, // to go througth current_word
	    length = current_word.length();
	char s_name =' ', s_indice =' ', c;
	
	if(a_position == 0)old_words[derive_count] = new String(current_word);
	while(i<a_position){
		new_word.append(current_word.charAt(i));
		i++;
	}
	  while(i<length){
		c = current_word.charAt(i);
		if(is_derivable(c)){
		  s_name=c;
		 
		  //c=current_word.charAt(i+1);
		  if(((i+2)< length) && (current_word.charAt(i+1)== '<')){
			c=current_word.charAt(i+2);
			if (!Character.isDigit(c)){ //indice follows
				s_indice=c;
				i = i+4; //<char> 3 char!!!
			}
		  else{ // no indice but appendix
			s_indice=' '; i++;}
		  }
		  else { s_indice=' '; i++;}
		  if(exsists_symbol(s_name, s_indice)){
			insertion = new String(get_symbol(s_name, s_indice).derive());
			new_word.append(insertion);
			//insertion = null; // for it can't do any stupid things
		  }
		  else{new_word.append(s_name);//derivation not possible
		  i++;}
		}//end is_derivable
		else{
		  new_word.append(c);
		  i++;
		}
	  }//end while
	current_word = new_word;
	a_position = 0;

}

/* *********************************************************** */
/* method derive_step()
 * derives only the next step rule of a_position important
 */ 

private void derive_step(){
	String insertion = new String();//for the rightsides 
	StringBuffer new_word = new StringBuffer();
	int i = 0, // to go througth current_word
		length = current_word.length();
	char s_name =' ', s_indice =' ', c;
	boolean found = false;// to search first derivable char

	if(a_position == 0) old_words[derive_count] = new String(current_word);

	while(i<a_position){//copies the derived string
		new_word.append(current_word.charAt(i));
		i++;
	}

	while((!found) && (i < length)){ // search first derivable char 
	   c=current_word.charAt(i);
	   if(is_derivable(c)){
		  s_name=c;
		  //c=current_word.charAt(i+1);
		  if(((i+2)< length) && (current_word.charAt(i+1)== '<')){
			// no indice etc possible
			c=current_word.charAt(i+2);
			if (!Character.isDigit(c)){ //indice follows
				s_indice=c;
				i = i+4; //<char> 3 char!!!
				if(exsists_symbol(s_name, s_indice)){
				insertion = new 
				 String(get_symbol(s_name, s_indice).derive());
				new_word.append(insertion);
				found = true;		}
				a_position = new_word.length();
		  	}
		  	else{ // following is an appendix
				s_indice = ' ';
				if (exsists_symbol(s_name, s_indice)){
			  	 insertion = new 
				  String(get_symbol(s_name, s_indice).derive());
				 new_word.append(insertion);
				 found = true;
				 a_position = new_word.length();
				 i++;
		  		}
		  		else{
				  new_word.append(s_name);
				  //derivation not possible
		  		  i++;}
			}
		}//end if(((i+2)< length) && (current_word.charAt(i+1)== '<'))

		  else { s_indice=' '; 
		  	if(exsists_symbol(s_name, s_indice)){
			  insertion = new 
				String(get_symbol(s_name, s_indice).derive());
			new_word.append(insertion);
			found = true;
			a_position = new_word.length();
			i++;
		  	}
		  	else{new_word.append(s_name);//derivation not possible
		  		i++;}
	   	}
	   }// end if(is_serivabl..)
	   else{
	   new_word.append(c); // derivation not possible
	   i++;
	}// end else
	}//while 
	if (i==length){// end of current_word reached by single derivations
		a_position = 0;
		derive_count++;
	}

	while(i<length){ // copy rest of current_word
		c=current_word.charAt(i);
		new_word.append(c);
		i++;
	}
	current_word = new_word;
}
/* *********************************************************** */
/* method prev()
 *
 */
public void prev(){
	current_word = new StringBuffer(old_words[derive_count - 1]);
	old_words[derive_count] = null;
	a_position = 0;
}

/* *********************************************************** */
/*  		methods to comunicate with Xui  	       */
/* *********************************************************** */
/* method get_axiom
 *
 */
public String get_axiom(){
	return new String(current_word);
}
	
/* method get_derivation
 *
 */
public String get_derivation(){
	derive_word();	
	derive_count++;
	return	new String(current_word);
}

/* method get_derivation
 * for single step
 */
public String single_derivation(){
	derive_step();
	return new String(current_word);
}

/* method previous_derivation()
 * returns a String
 */
public String previous_derivation(){
	// it's impossible to call this method if derive_count<1 -> Xui.prev()
	prev();
	derive_count--;
	return  new String(current_word);
}
/* method get_position()
 * returns a_position, to be able the draw 
 */
public int get_position() {
	return a_position;
}



}


/* ************************************************** */
/* class:	Symbol
 * description: data strucure symbol
 * constructores: Symbol(char symb, char indice)
 * instance methods: 	public boolean test_prob
 *			public boolean add_rule
 *			public String derive 
 */

class Symbol { 

	private int rule_number = 0; // number of rules for this Symbol
	private String[] rules = new String[50]; // all right sides of 
						//productions which left side 
						//is symbol in  form of strings
	private double[] probab = new double[10]; // the probabilities for the
					          // rules in Vector rules 
	private double prob_sum = 0.0; // the sum of all probabilities

	public char 	name, // name of this Symbol
	       		indice; // the index of this Symbol

	/* ****************************************************** */
	/* 		C O N S T R U C T O R S                   */
	/* ****************************************************** */

	public Symbol(char symb, char indice) {
		this.name = symb;
		this.indice = indice;
	
	}

	/* ****************************************************** */
	/*         I N S T A N C E   M E T H O D S	          */
	/* ****************************************************** */

	/* method add_rule
	 * description adds a new rule to Array rules
	 * arguments a rule, a probability
	 * returns non
	 */
	public void add_rule(String rightside, double p){
		prob_sum = prob_sum + p;
		rules[rule_number] = rightside;
		probab[rule_number] = p;
		rule_number++;
	}

	/* ****************************************************** */

	/* method test_prob
	 * description tests, whether the sum of probabilities is 1.0
	 * arguments non
	 * returns boolean
	 */
	public boolean test_prob() {
		return (Math.abs(prob_sum - 1.0) < 0.01);
	}

	/* ****************************************************** */
	
	/* method derive
	 * description 	returns a string with a rigthside of a rule,
	 *     	 	which left side is this
	 * arguments non
	 */
	public String derive() {
		double sum = 0, 
			x; // a random value
		int i = 0;
		
		if(rule_number != 1){ // switch a rule by random
			x = Math.random();
			while((sum<x) && (i < rule_number)) {
			  sum = sum + probab[i];
			  i++;
			}
		return rules[i-1];
		}
		else{return rules[i];}
	}

}

/* ************************************************************* */
/* for a better Exception handling in grammar initilisation
 */
class GrammarInitFailedException extends Exception{
	public static String 	e1 = new String("no Grammar found"),
				e2 = new String("Parenties are not correct"),
				e3 = new String("probabilities are not correct"),
				e4 = new String("general problems with initalization");

	// constructores
	public GrammarInitFailedException(String s){
		super(s);
	}
}






