package lgrammar;

import java.awt.*;
import java.io.*;
import java.net.*;

/* ************************************************* */
/* class name InOut
 * to read and write grammars through an url
 */

public final class InOut{
	private static InOutWindow winOpen;
	private static Xui xui  = null;
	public static char newline  = '\n';
	private static String ENDE = "Ende";

	/* **************************************************** */
	/*   		L O A D   G R A M M A R			*/
	/****************************************************** */

	public static void load(Xui x){
	// method called by xui
		xui = x;
		winOpen = new InOutWindow(xui);
		open(winOpen);
	}

	public static void load(String urlString) {
	// called by InOutWindow
	// tries to load the indicated url
		URL url = null;
		URLConnection connection = null;
		InputStream in = null;
		String all;
		try{
		     url = new URL(urlString);
		     connection = url.openConnection();
		     in = connection.getInputStream();
		     all = getContent(in);
		     in.close();
		     load_in_xui(all);
		} catch (Exception e){
			show_message("Grammar load failed \n" + 
				InOutException.e1);
		}
	}

	private static void load_in_xui(String string) throws InOutException{
		String  line = null;
		Str all = new Str(string);
		Color[] color;
		int j = 0,
		    hint = 0; // for type convertions
		try{
			// read color
			line = all.readLine();
			hint = Integer.parseInt(line);
			if(hint < Colors.OWN){
				xui.colors.set_Color(hint);
			} else {
			  int r, g, b;
			  color = new Color[Colors.COLOR_NUM];
			  for (j=0; j<Colors.COLOR_NUM; j++){
				line = all.readLine();
				r = Integer.parseInt(line);
				line = all.readLine();
				g = Integer.parseInt(line);
				line = all.readLine();
				b = Integer.parseInt(line);
				color[j] = new Color(r, g, b);
			  }
			  xui.colors.set_Color(color);
			}
		 	// set projection
			int x, y, a;
			line = all.readLine();
			x = Integer.parseInt(line);
			line = all.readLine();
			y = Integer.parseInt(line);
			line = all.readLine();
			a = Integer.parseInt(line);
			xui.projection.set_values(x,y,a);
			// set the textfields
			line = all.readLine();
			xui.t_posx.setText(line);
			line = all.readLine();
			xui.t_posy.setText(line);
			line = all.readLine();
			xui.t_posz.setText(line);
			line = all.readLine();
			xui.t_angle.setText(line);
			line = all.readLine();
			xui.t_length.setText(line);
			line = all.readLine();
			xui.t_scale.setText(line);
			line = all.readLine();
			xui.t_headx.setText(line);
			line = all.readLine();
			xui.t_heady.setText(line);
			line = all.readLine();
			xui.t_headz.setText(line);
			line = all.readLine();
			xui.t_leftx.setText(line);
			line = all.readLine();
			xui.t_lefty.setText(line);
			line = all.readLine();
			xui.t_leftz.setText(line);
			line = all.readLine();
			xui.t_upx.setText(line);
			line = all.readLine();
			xui.t_upy.setText(line);
			line = all.readLine();
			xui.t_upz.setText(line);	
			// last read grammar
			StringBuffer sb = new StringBuffer();
			line = all.readLine();
			sb.append(line);
			line = all.readLine(); 
			while(! line.equalsIgnoreCase(ENDE)){
			    sb.append(newline);
			    sb.append(line);
			    line = all.readLine();
			}
			xui.grammartxt.setText(new String(sb));
		} catch (Exception e){
			show_message("Grammar load failed \n"+ e.getMessage());
		}
	}

	public static String getContent(InputStream in){
		// converts the InputStream in a String

		int   	available = 0,
			i = 0;
		try{
			available = in.available();
		} catch(IOException e){} 
		byte[] data = new byte[available];
		String content;
		try{
		  while(i<available)
			i += in.read(data, i, available-i);
		} catch (IOException e) {
			show_message("Grammar load failed \n" + 
				e.getMessage());
		}
		content = new String(data, 0);
		return content;
	}


	/* ***************************************************** */

	public static void open(InOutWindow win){
	// opens the inoutwindow
		win.init();
		win.pack();
		win.show();
	}

	public static  void show_message(String error){
		FailureWin win = new FailureWin(xui, error);
		win.init();
		win.pack();
		win.show();
	} 

}
/* *************************************************** */
/* class Str
 * to treat s String as a file!!
 */
class Str{
	String astring = null;
	int position = 0;
	// constructor
	public Str(String string){
		astring = string;
	}	
	public String readLine(){
	// returns the substring to the first newline
		String s;
		StringBuffer sb = new StringBuffer();
		while(astring.charAt(position) != InOut.newline){
			sb.append(astring.charAt(position));
			position++;
		}
		s = new String(sb);
		position++;
		return s;
	}
}

/* ************************************************** */
/* class name InOutWindow
 * a window to enter an url
 */

class InOutWindow extends Frame{
	static String defurl;
	static final String notification = "Please enter a Grammar";
	String config = null; 
	Label l = new Label(notification);
	Button 	b_ok = new Button ("OK"),
		b_clear = new Button("Clear"),
		b_cancel = new Button("Cancel");
	TextField t = new TextField(50);
	TextArea a = new TextArea(10, 50);
	String url = null;
	boolean opened = false;
	// constructor

	public InOutWindow(Xui xui){
		super("URL");
		URL url = xui.getCodeBase();
		defurl = url.toString() + "examples/";
	}

	// instance methods

	public void init(){
		if(!opened){
			a.setText(read_config());
			a.setEditable(false);
			t.setText(defurl);
			Panel p1 = new Panel();
			Panel p2 = new Panel();
			Panel p3 = new Panel();
			p3.setLayout(new GridLayout(2, 1));
			p1.setLayout(new FlowLayout());
			p1.add(b_ok);
			p1.add(b_clear);
			p1.add(b_cancel);
			p2.setLayout(new BorderLayout());
			p2.add("North", l);
			p2.add("Center", new Label
				("Name              Desription"));
			p2.add("South", a);
			p3.add(t);
			p3.add(p1);
			setLayout(new BorderLayout());
			add("North", p2);
			add("South", p3);
			opened = true;
		}
	}
	private String read_config(){
		String s = defurl + "config";
		URL url = null;
		URLConnection connection = null;
		InputStream in = null;
		String all = "";
		try{
		     url = new URL(s);
		     connection = url.openConnection();
		     in = connection.getInputStream();
		     all = InOut.getContent(in);
		     in.close();
		} catch (Exception e){
			InOut.show_message("Grammar load failed \n" + 
				InOutException.e3 + "\n" + defurl);
		}
		return all;
	}

	public boolean action(Event e, Object o){
		if(e.target == b_ok){
			url = t.getText();
			this.hide();
			InOut.load(url);
			return true;
		}
		if(e.target == b_clear){
			t.setText("");
			t.setText(defurl);
			return true;
		}
		if(e.target == b_cancel){
			url = null;
			this.hide();
			return true;
		} else {
			return true;
		}
	}
}



/* *********************************************** */
/* class name InOutException
 * Exception to handel with  InOut
 */

class InOutException extends Exception{
	public static final String
		e1 = "URL not found",
		e2 = "Indicate file as no lgrammar format",
		e3 = "Config File is missing";
	// constructor
	public InOutException(String s){
		super(s);
	}
} 













