/* filename 	Xui.java
 * class :  	Xui.java
 * description: main part of lgrammar
 *		user interface and basic controll functions
 * methods in Xui :  	init()
 *			action()
 *			repait()
 *			set_2D()
 *			set_3D()
 *			set_dimens()
 *			grammar_ok()
 *			stop()
 *			turtle2_init()
 *			turtle3_init()
 *			next() 
 *			prev()
 * 			single()
 *			load()			
 */ 

package lgrammar;

import java.awt.*;
import java.applet.Applet;
import java.net.*;

public class Xui extends java.applet.Applet {

	// subclasses
 
	private Grammar grammar = null; // grammar string
	private Turtle2 turtle2 = null;  // a 2D turtle
	private Turtle3 turtle3 = null; // a 3D turtle
	private Draw2 draw2  = null;
	private Draw3 draw3  = null;	

	public Colors colors = new Colors();
	ColorWin colorwin = new ColorWin(colors);
	boolean colorshown = false;
	public Projection projection = new Projection();

	// UserInterfaceComponetsDeclarations
	
	public static String help, about;
	public static final Font lgrammarFont = new Font("Helvetica", Font.PLAIN, 12); 
	private Label derivation   = new Label("Derivation 0"), // the derivation depth
		      dimension = new Label("Dimension 3") , // shows the dimension
		      title = new Label("    Lgrammar - A Tool for Evaluating Lindenmayer Systems      "); // title of the applet   
	private Panel 	all = new Panel(), 	// contains all except the headline
			headline = new Panel(), // contains the headline
			input =  new Panel(), // contains all Buttons etc 
			draw  =  new Panel(), // contains the draw area
			information = new Panel(),

			first  = new Panel(), // shows the current word
			second = new Panel(), // for input of turtle values
	      		third  = new Panel(), // grammar input amd some buttons

			left = new Panel(), // component of second
			right = new Panel(),// component of second
 			middle = new Panel(), // component of second

 			p_cb = new Panel(),  // for Ceckboxgroup
			ctrl1  =  new Panel(), // part of third only needed 
					// in the appletviewer version
			ctrl2  = new Panel(),  //  - " -
			p_gr   = new Panel(), // component of third
			deriv  = new Panel(); // main part of second

	private Canvas  draw_area = new Canvas();
	public TextField t_posx, t_posy, t_posz, t_angle, // Turtle values ...
			 t_length, t_scale, t_headx, 
			 t_heady, t_headz, t_leftx, t_lefty, 
			 t_leftz, t_upx, t_upy,  t_upz;

	public Button b_proj, b_color, b_refresh, b_init, 
		      b_next, b_prev,  b_single,  
		      b_load, b_help, b_about;

	public TextArea grammartxt = new TextArea(6, 200),
			 presentWord = new TextArea(2, 200);


	public void init() {
		
		headline.setLayout(new FlowLayout());
		input.setLayout(new BorderLayout());
		draw.setLayout(new BorderLayout());
		information.setLayout(new FlowLayout());

		first.setLayout(new BorderLayout());
		second.setLayout(new BorderLayout());
		third.setLayout(new BorderLayout());

		deriv.setLayout(new GridLayout(1,3));
		left.setLayout(new GridLayout(6, 3));
		middle.setLayout(new GridLayout(6, 3));
		right.setLayout(new GridLayout(6,3));
		p_gr.setLayout(new BorderLayout());

		// Initialisierung der TextFields
		t_posx  = new TextField("100",4); 
		t_posy  = new TextField("100", 4);
		t_posz	= new TextField("0", 4); 
		t_angle = new TextField("90", 4);
	        t_length= new TextField("300",4);
 		t_scale = new TextField("4",4); 
		t_headx = new TextField("0",4); 
		t_heady = new TextField("1",4); 
		t_headz = new TextField("0",4);
		t_leftx = new TextField("-1", 4); 
		t_lefty = new TextField("0",4); 
		t_leftz = new TextField("0",4); 
		t_upx   = new TextField("0", 4); 
		t_upy   = new TextField("0",4);  
		t_upz   = new TextField("1", 4);

		// Initialization of Buttons
		b_proj   = new Button("Proj");
		b_color  = new Button("Color");	
		b_refresh = new Button("Refresh");
		b_init   = new Button("Init");
		b_next   = new Button("Next");
		b_prev	 = new Button("Prev");
		b_single = new Button("Single");
		b_load   = new Button("Load");
		b_about  = new Button("About");
		b_help 	 = new Button("Help");
		b_next.disable();
		b_prev.disable();
		b_single.disable();


		// components of first
		first.add("North", new Label("Present Word"));
		first.add("Center", presentWord);
		
		// components of second
		left.add(new Label("Pos.x"));
		left.add(new Label("Pos.y"));
		left.add(new Label("Pos.z"));
		left.add(t_posx);
		left.add(t_posy);
		left.add(t_posz);
		left.add(new Label("Angle"));
		left.add(new Label("Length"));
		left.add(new Label("Scale"));
		left.add(t_angle);
		left.add(t_length);
		left.add(t_scale);
		 for (int i=0; i<6; i++){    // thus the componets of  left
		  left.add(new Label(" "));  // and middle have the same size
		  }			 	
		middle.add(new Label("Head.x"));
		middle.add(new Label("Head.y"));
		middle.add(new Label("Head.z"));
		middle.add(t_headx);
		middle.add(t_heady);
		middle.add(t_headz);
		middle.add(new Label("Left.x"));
		middle.add(new Label("Left.y"));
		middle.add(new Label("Left.z"));
		middle.add(t_leftx);
		middle.add(t_lefty);
		middle.add(t_leftz);
		middle.add(new Label("Up.x"));
		middle.add(new Label("Up.y"));
		middle.add(new Label("Up.z"));
		middle.add(t_upx);
		middle.add(t_upy);
		middle.add(t_upz);
		
		// components of right
		/* for loops to fill the gaps!!*/
		for (int i=0; i<4; i++){right.add(new Label (" "));}
		right.add(b_proj);
		right.add(b_color);

		for (int i=0; i<4; i++){
			right.add(new Label (" "));
		}
		right.add(b_refresh);

		// this 3 componets together in deriv
		deriv.add(left);
		deriv.add(middle);
		deriv.add(right);
		
		derivation = new Label("Derivation 0");
		information.add(derivation);
		information.add(dimension);

		second.add("North", information);
		second.add("South", deriv);
	
		//components of third
		


		ctrl2.add(b_init);
		ctrl2.add(b_next);
		ctrl2.add(b_prev);
		ctrl2.add(b_single);
		ctrl2.add(new Label("     ")); // to leave some space
		ctrl2.add(b_load);
		p_gr.add("North", new Label("Grammar"));
		p_gr.add("Center", grammartxt);

		third.add("North", p_gr);
		third.add("Center", ctrl2);
		third.add("South", ctrl1);

		// all together in the input

		input.add("North", first);
		input.add("Center", second);
		input.add("South", third);
		

		// finally the draw area:
		
		draw.add("Center", draw_area);
		draw.add("North",new Label("Drawing"));
	
		// together in all
		all.setLayout(new GridLayout(1,2));
		setFont(lgrammarFont);
		all.add(input);
		all.add(draw);

		// init the headline
		headline.add(b_help);
		title.setFont(new Font("TimesRoman", Font.BOLD, 20));
		headline.add(title);
		headline.add(b_about); 
		
		// all together in the applet
		setLayout(new BorderLayout());
		add("North", headline);
		add("Center", all);
		repaint();        
}

/* ************************************************************* */
/* method stop()
 */
        public void stop(){
                super.stop();
                b_init.enable();
        }

/* ************************************************************* */
/* method paint 
 * draws a frame around the drawing-area
 */
        public void paint(Graphics g){
                Dimension d = draw_area.size();
                Graphics g2;
                g2 = draw_area.getGraphics();
                g2.drawRect(2, 2, d.width-4, d.height-4);
        }

/* ************************************************************* */
/* method action
 * deals with all events oin the applet and
 * calls the according methods
 */
        public boolean action (Event e, Object o){
		if("Help".equals(o)){
			try{
				help = getParameter("help");
				URL url = new URL(getCodeBase(), help);
				System.out.println("GOTO: " + url);
				getAppletContext().showDocument(url);
			} catch(MalformedURLException ex) {}
			return true;
		} 
		if("About".equals(o)){
			try{
				about = getParameter("about");
				URL url = new URL(getCodeBase(),  about);
				System.out.println("GOTO: " + url);
				getAppletContext().showDocument(url);
			} catch(MalformedURLException ex) {}
			return true;
		} 
	       	if ("Load".equals(o)) {
			load();
			return(true);}
		if("Next".equals(o)){
			next();
			return (true);
		}
		if ("Init".equals(o)) {
			grammar_ok();
			return(true);
		}
		if("Prev".equals(o)){
			prev();
			return(true);
		}
		if("Single".equals(o)){
			single();
			return(true);
		}
		if("Proj".equals(o)){
		  	proj();
		  	return true;
		}
		if("Color".equals(o)){
		 	color();
		  	return true;
		}
		if ("Refresh".equals(o)){
			refresh();
			return true;
		}
	       else {return super.action(e, o);}

}
/* ************************************************************* */
/*method name  set_3D
 * method to active 3D-format
*/
protected void set_3D(){
	b_proj.enable();
}

/* ************************************************************* */
/* method name set_2D
 * description method to active 2D-format
*/
protected void set_2D(){
	b_proj.disable();

}
/* ************************************************************* */
/* method set_dim
 *
 */
private void set_dim() { 
	int d = grammar.dimen;
	if (d == 2) {set_2D();}
	else {set_3D();}
	dimension.setText("Dimension  " + (new Integer(d)).toString());
}
	

/* ************************************************************* */
/* method set_deriv
 *
 */
private void set_deriv() { 
	int d = grammar.derive_count;
	derivation.setText("Derivation  " + (new Integer(d)).toString());
}
	
/* ************************************************************* */
/* method grammar_ok
 * checks the input grammar and starts the turtle
 */

private void grammar_ok() {

	String  grammar_str,
	        message = null,
		axiom = null;
	int dimension = 3;
	Color[] color = colors.get_Color();  
	FailureWin win;


	grammar_str =new String(grammartxt.getText());
	int length = grammar_str.length();
	if((length > 0) && (grammar_str.charAt(length - 1)!= '\n'))
			 grammar_str=grammar_str +"\n";
	grammar = new Grammar(grammar_str);
	set_deriv();
	try { grammar.test_and_init();
		axiom = grammar.get_axiom();
	      	presentWord.setText(axiom);
		if (draw2 != null) draw2.clear();
		if (draw3 != null) draw3.clear();
		if (grammar.dimen ==  2){
			draw3 = null;
			turtle2_init();
			draw2 = new Draw2(axiom, draw_area, color , turtle2);
			draw2.clear();	
			draw2.repaint();
			this.repaint();
		}
		else{
			draw2 = null;
			turtle3_init();
			draw3 = new Draw3(axiom, draw_area, color, turtle3);
			draw3.clear();
			draw3.repaint();
			this.repaint();
		}
		b_next.enable();
		b_single.enable();
		b_prev.disable();
		set_dim();
		}
	catch(GrammarInitFailedException f){
		message=new String("Grammar initisalization failed \n" + 
					f.getMessage());		
		win = new FailureWin(this, message);
		b_init.disable();
		win.init();
		win.move(100, 200);
		win.pack();
		win.show();

	}
	catch(Exception e){
		message=new String("Grammar initisalization failed \n" + 
					e.getMessage());			
		win = new FailureWin(this, message);
		b_init.disable();
		win.init();
		win.pack();
		win.show();

	}
}
/* ***************************************************** */
/* method turtle2_init()
 * initialize turtle2
 */
public void turtle2_init(){
	Dimension d = draw_area.size(); // for the turtle could start in left under edge
	int  	length;
	double  posx,
		posy,
		headx,
		heady,
		angle,
		scale;
	try{
	    posx = Double.valueOf(t_posx.getText()).doubleValue();
	   }
	catch (NumberFormatException e) {
		posx = 100; // default value
		t_posx.setText("100");
	}
	try{
	    posy = Double.valueOf(t_posy.getText()).doubleValue();
	   }
	catch (NumberFormatException e) {
		posy = 100; // default value
		t_posy.setText("100");
	}
	try{
	    length = Integer.parseInt(t_length.getText());
	   }
	catch (NumberFormatException e) {
		length = 300; // default value
		t_length.setText("300");
	}
	try{
	    angle = Double.valueOf(t_angle.getText()).doubleValue();
	   }
	catch (NumberFormatException e) {
		angle = 90; // default value
		t_angle.setText("90");
	}
	try{
	    scale = Double.valueOf(t_scale.getText()).doubleValue();
	   }
	catch (NumberFormatException e) {
		scale = 4; // default value
		t_scale.setText("4");
	}
	try{
	    headx = Double.valueOf(t_headx.getText()).doubleValue();
	   }
	catch (NumberFormatException e) {
		headx = 1; // default value
		t_headx.setText("0");
	}
	try{
	    heady = Double.valueOf(t_heady.getText()).doubleValue();
	   }
	catch (NumberFormatException e) {
		heady = 1; // default value
		t_heady.setText("1");
	}

	turtle2 = new Turtle2(new Vector2(posx,(double)d.height-posy, false),
			     new Vector2(headx, -heady, true),
			     angle, scale, length);
} 
/* ***************************************************** */
/* method turtle3_init()
 * initialize turtle3
 */
public void turtle3_init(){
	Dimension d = draw_area.size(); // for the turtle could start in left under edge
	int  	length;
	double  posx, posy, posz,
		headx, heady, headz,
		leftx, lefty, leftz,
		upx, upy, upz,
		angle,
		scale;
	try{
	    posx = Double.valueOf(t_posx.getText()).doubleValue();
	   }
	catch (NumberFormatException e) {
		posx = 100; // default value
		t_posx.setText("100");
	}
	try{
	    posy = Double.valueOf(t_posy.getText()).doubleValue();
	   }
	catch (NumberFormatException e) {
		posy = 100; // default value
		t_posy.setText("100");
	}
	try{
	    posz = Double.valueOf(t_posz.getText()).doubleValue();
	   }
	catch (NumberFormatException e) {
		posz = 0; // default value
		t_posz.setText("0");
	}
	try{
	    length = Integer.parseInt(t_length.getText());
	   }
	catch (NumberFormatException e) {
		length = 300; // default value
		t_length.setText("300");
	}
	try{
	    angle = Double.valueOf(t_angle.getText()).doubleValue();
	   }
	catch (NumberFormatException e) {
		angle = 90; // default value
		t_angle.setText("90");
	}
	try{
	    scale = Double.valueOf(t_scale.getText()).doubleValue();
	   }
	catch (NumberFormatException e) {
		scale = 4; // default value
		t_scale.setText("4");
	}
	try{
	    headx = Double.valueOf(t_headx.getText()).doubleValue();
	   }
	catch (NumberFormatException e) {
		headx = 0; // default value
		t_headx.setText("0");
	}
	try{
	    heady = Double.valueOf(t_heady.getText()).doubleValue();
	   }
	catch (NumberFormatException e) {
		heady = 1; // default value
		t_heady.setText("1");
	}
	try{
	    headz = Double.valueOf(t_headz.getText()).doubleValue();
	   }
	catch (NumberFormatException e) {
		headz = 0; // default value
		t_headz.setText("0");
	}
	try{
	    leftx = Double.valueOf(t_leftx.getText()).doubleValue();
	   }
	catch (NumberFormatException e) {
		leftx = 1; // default value
		t_leftx.setText("-1");
	}
	try{
	    lefty = Double.valueOf(t_lefty.getText()).doubleValue();
	   }
	catch (NumberFormatException e) {
		lefty = 0; // default value
		t_lefty.setText("0");
	}
	try{
	    leftz = Double.valueOf(t_leftz.getText()).doubleValue();
	   }
	catch (NumberFormatException e) {
		leftz = 0; // default value
		t_leftz.setText("0");
	}
	try{
	    upx = Double.valueOf(t_upx.getText()).doubleValue();
	   }
	catch (NumberFormatException e) {
		upx = 0; // default value
		t_upx.setText("0");
	}
	try{
	    upy = Double.valueOf(t_upy.getText()).doubleValue();
	   }
	catch (NumberFormatException e) {
		upy = 0; // default value
		t_upy.setText("0");
	}
	try{
	    upz = Double.valueOf(t_upz.getText()).doubleValue();
	   }
	catch (NumberFormatException e) {
		upz = 1; // default value
		t_upz.setText("1");
	}
	turtle3 = new Turtle3(projection, 
			     new Vector3(posx,(double)d.height-posy, posz),
			     new Vector3(headx, -heady, headz),
			     new Vector3(upx, upy, upz),
			     new Vector3(leftx, lefty, leftz),
			     angle, scale, length);
} 


/* ***************************************************** */
/* method next()
 * gets the next derivation from grammar and let's
 * draw2/3 to draw it
 */
private void next(){
	String word = null;
	int position = grammar.get_position();

	// buttons disable
	b_next.disable();
	b_prev.disable();
	b_single.disable();

	word =  grammar.get_derivation();
	set_deriv();
	presentWord.setText(word);
	if(draw3 == null){
		draw2.clear();
		this.repaint();
		draw2.draw_next(word);
	} else{
		draw3.clear();
		this.repaint();
		draw3.draw_next(word);
	}
	//enable buttons
	b_init.enable();
	int i = grammar.derive_count;
	if( i < grammar.MAXDERIVES - 1){ 
		b_next.enable();
		b_single.enable();
	}
	b_prev.enable();
}

/* ***************************************************** */
/* method prev()
 * gets the  previous derivation
 *
 */
private void prev(){
	String word = new String(grammar.previous_derivation());
	presentWord.setText(word);
	int d = grammar.derive_count;
	repaint();
	if(draw3 == null) {
		draw2.clear();
		draw2.draw_prev(word);
		this.repaint();
	} else {
		draw3.clear();
		draw3.draw_prev(word);
		this.repaint();
	}
	if(d<=1) b_prev.disable();
	set_deriv();
	b_next.enable();
	b_single.enable();
}
/* ***************************************************** */
/* method single()
 * derives only the next derivable symbol
 *
 */
private void single(){
	String word = null;
	int position = 0;

	// buttons disable
	b_init.disable();
	b_next.disable();
	b_prev.disable();
	b_single.disable();
	word = new String(grammar.single_derivation());
	position = grammar.get_position();
	presentWord.setText(word);
	set_deriv();
	
	// draw word
	if(draw3 == null){
		draw2.clear();
		this.repaint();
		draw2.draw_single(word, position);
	} else {
		draw3.clear();
		this.repaint();
		draw3.draw_single(word, position);
	}	

	//enable buttons
	b_init.enable();
	int i = grammar.derive_count;
	if( i <grammar.MAXDERIVES - 1){ 
		b_next.enable();
		b_single.enable();
	}
	if (grammar.derive_count > 0) b_prev.enable();
}

/* ***************************************************** */
/* method color()
 * opens a window in which you can choose a color palette
 */
public void color(){
	if (colorshown){
		colorwin.show();
	}
	else {
	colorshown = true;
	colorwin.init();
	colorwin.pack();
	colorwin.show();
	}
}
/* ***************************************************** */
/* method proj()
 * opens a window in which you can initialise the projection datas 
 */
private void proj(){
	ProjWin projwin = new ProjWin(projection, this);
	b_proj.disable();
	projwin.init();
	projwin.pack();
	projwin.show();
}
/* ***************************************************** */
/* method refresh()
 * refreshs the graphic
 */
private void refresh(){
	if (draw2 != null){
		draw2.repaint();
	} 
	if (draw3 != null){
		draw3.repaint();
	}
	this.repaint();
}
/* ***************************************************** */
/* method load()
 *
 */
private void load(){
	InOut.load(this);

}

}




