.TH XP3GDB 1.01 "May 1996" "X Version 11"
.SH NAME
xp3gdb \- X window system interface to the p3gdb debugger.
.SH SYNOPSIS
.B xp3gdb
[ \fI-toolkitoption ... \fP] [\fI-xp3gdboption ... \fP] [\fI-gdboption ... \fP] [\fIobjfile\fP
[ \fIcorefile\fP ]]
.SH DESCRIPTION
\fIXp3gdb\fP is a graphical user interface to the \fIgdb\fP debugger under the
X Window System.  It provides visual feedback and mouse input for the
user to control program execution through breakpoints, to examine and
traverse the function call stack, to display values of
variables and data structures, and to browse source files and functions.
.LP
\fIXp3gdb\fP allows initial gdb commands stored in the file \fI.gdbinit\fP
to be executed immediately after the symbolic information is
read.  If \fI.gdbinit\fP does not exist in the current directory, the
user's home directory is searched (\fI~/.gdbinit\fP). Option -nx
can be used to prevent xp3gdb from executing this file. Option -gdbinit
can be used to change the file name of command file.
.LP
\fIObjfile\fP is an object file produced by a compiler with the
appropriate option (-g) specified to produce symbol table
information for gdb.
.LP
If a file named \fIcore\fP exists in the current directory or a
\fIcorefile\fP is specified, \fIxp3gdb\fP can be used to examine the
state of the program when the core dump occurred.
.LP
The name of the debugger invoked by \fIxp3gdb\fP is, by default, gdb, but
it can be overridden with the environment variable XP3GDB_DEBUGGER or with
the db_name option.
.SH OPTIONS
\fIXp3gdb\fP accepts all of the standard X Toolkit command line options
(see \fIX\fP(1)), and all the gdb options (see \fIgdb\fP(1)), plus
the following xp3gdb specific options:
.IP -db_name debuggername
Specify the name of the debugger to override the default "gdb"
.IP -db_prompt promptstring
Specify to xp3gdb what is the debugger prompt. The default is to
expect the prompt to be the name of the debugger enclosed in
parenthesis followed by a space (eg, "(gdb) ").
.IP -gdbinit filename
Specify the filename of initial gdb command file. The default
is ".gdbinit".
.IP -nx
Do not execute .gdbinit file.
.IP -bigicon
Uses a 64x64 icon instead of the default 48x48 icon.
.IP -cs colorScheme
Normally \fIxp3gdb\fP will try to figure out the visual of the current
screen and create a corresponding color mapping table. With this
option you can override the default for a color visual to be treated
as a gray visual. No other color scheme overriding is currently
supported. Please use as argument \fIgray\fP or \fIgrey\fP.
.SH SUBWINDOWS
\fIXp3gdb\fP consists of the following subwindows:
.IP "File Window" 20
Display the full pathname of the file displayed in the source window,
and the line number of the caret.
.IP "Source Window" 20
Display the contents of a source file.
.IP "Message Window" 20
Display the execution status and error messages of \fIxp3gdb\fP .
.IP "Command Window" 20
Provide a list of the common gdb commands which are invoked by simply
clicking the LEFT mouse button.
.IP "Dialogue Window" 20
Provide a typing interface to gdb.
.IP "Display Window" 20
Provide a window for displaying variables each time execution stops.
.IP "Popup Windows" 20
Provide windows for displaying variables (see "Displaying C Data
Structures" below).
.LP
The relative sizes of the source window, command window, and the dialogue
window can be adjusted by dragging the grip (a small square near the
right edge of a horizontal border) with the LEFT mouse button down.
.SH SELECTION
Text selection in the source window is modified to make it easier to
select C expressions.  LEFT mouse button down selects a C expression by
highlighting it in reverse-video.  LEFT mouse button down also positions the
caret and updates the line label accordingly.
.LP
C expression selection is based on the resource \fIdelimiters\fP which
determines the set of characters that delimits a C expression.  (The
default word selection behavior in the Athena text widget selects a
word delimited by white spaces.)  Text selection adjustment is possible
by holding the LEFT mouse button down and dragging.
.LP
A LEFT mouse button click with the SHIFT button down prints the value
of the expression selected.
.LP
.SH SCROLLBAR
Pressing the LEFT mouse button scrolls the text forward, whereas
pressing the RIGHT mouse button scrolls the text backward.  The amount
of scrolling depends on the distance of the pointer button away from
the top of the scrollbar.  If the button is pressed at the top of the
scrollbar, only one line of text is scrolled.  If the button is pressed
at the bottom of the scrollbar, one screenful of text is scrolled.
.LP
Pressing the MIDDLE mouse button changes the thumb position of the
scrollbar.  Dragging the MIDDLE mouse button down moves the thumb along
and changes the text displayed.
.SH COMMAND BUTTONS
.SS "Execution Commands"
.IP "\fBrun\fP" 12
Begin program execution.
.IP "\fBcont\fP"
Continue execution from where it stopped.
.IP "\fBnext\fP"
Execute one source line, without stepping into any function call.
.IP "\fBstep\fP"
Execute one source line, stepping into a function if the source line
contains a function call.
.IP "\fBfinish\fP"
Continue execution until the selected procedure
returns; the current procedure is used if none is selected.

.LP
.SS "Breakpoint Commands"
.IP "\fBbreak\fP" 10
Stop program execution at the line or in the function selected.  To
set a breakpoint in
the program, place the caret at the start of the source line or on the
function name and click
the \fBbreak\fP button.  A stop sign will appear next to the source line.
.IP "\fBtbreak\fP" 10
Set a breakpoint enabled only for one stop.  This is the same as the
\fBbreak\fP button except the breakpoint is automatically disabled the
first time it hit.
.IP "\fBdelete\fP"
Remove the breakpoint on the source line selected or the breakpoint
number selected.
.IP "\fBdelete all\fP"
Like \fBdelete\fP, but remove all breakpoints (both active and inactive).
.IP "\fBshow brkpts\fP"
Show the current breakpoints (both active and inactive).

.LP
.SS "Stack Commands"
.IP "\fBstack\fP" 10
Show a stack trace of the functions called.
.IP "\fBup\fP"
Move up one level on the call stack.
.IP "\fBdown\fP"
Move down one level on the call stack.

.LP
.SS "Data Display Commands"
.IP "\fBPE USAGE\fP" 10
Display the usage of a selected processor configuration. (also see
"Special Vector Commands" below)
.IP "\fBprint\fP"
Print the value of a selected expression. (also see "Displaying C Data
Structures" below)
.IP "\fBprint VECTOR\fP"
Show the value of the object the selected expression is pointing
to, opens a popup window. (also see "Special Vector Commands" below)
.IP "\fBdisplay\fP"
Display the value of a selected expression in the display window,
updating its value every time execution stops.
.IP "\fBdisp VECTOR\fP"
Display the value of a selected expression in a display window,
updating its value every time execution stops. (also see "Special
Vector Commands" below)
.IP "\fBundisplay\fP"
Stop displaying the value of the selected expression in the display
window.  If the selected expression is a constant, it refers to the
display number associated with an expression in the display window.
.IP "\fBundisplay all\fP"
Like \fBundisplay\fP, but remove all display expressions.
.IP "\fBshow display\fP"
Show the names of currently displayed expressions.
.IP "\fBargs\fP"
Print the arguments of the selected frame.
.IP "\fBlocals\fP"
Print the local variables of the selected frame.
.IP "\fBstack\fP"
Print a backtrace of the entire stack.

.LP
.SS "Miscellaneous Commands"
.IP "\fBsearch\fP"
Pop up a search panel which allows both forward (>>) and reverse (<<)
search of text strings in the source file.  Hitting carriage return
after entering the search string will begin a forward search and pop
down the search panel.
.IP "\fBinterrupt\fP"
Will terminate the \fBstep\fP loop when a \fBPE USAGE\fP window is
open and the menu entry \fIAuto stepping\fP is enabled.
.IP "\fBfile\fP"
Pop up a directory browser that allows the user to move up and down
in the directory tree, to select a text file to be displayed, to
select an executable file to debug, or to select a core file to debug.
Directory entries are marked with a trailing slash (`/') and executables
with a trailing asterisk (`*').  Filenames beginning with a dot (`.')
or ending with a tilde (`~') are not listed in the menu.
.IP "\fBsearch\fP"
Pop up a search panel which allows both forward (>>) and reverse (<<)
search of text strings in the source file.  Hitting carriage return
after entering the search string will begin a forward search and pop
down the search panel.
.IP "\fByes\fP"
Send 'y' (yes) to gdb. To be used when gdb requires a yes/no response.
.IP "\fBno\fP"
Send 'n' (no) to gdb. To be used when gdb requires a yes/no response.
.IP "\fBquit\fP"
Exit \fIxp3gdb\fP.

.LP
.SS "Special Vector Commands
.IP "\fBPE USAGE\fP"
Pop up a window with a graphical representation of the amount of
processors in use for a special configuration. When clicking in the
command widget on top of the window, a menu will pop up. The style of
view can be changed through the \fISettings\fP entry between
\fIsolid\fP and \fIpoint\fP, \fIabsolute\fP and
\fIrelative\fP. \fIScale lines\fP can be activated. Also \fIhorizontal
zooming\fP can be modified. Vertical zooming is done automatically,
depending on the window size.

Through the menu entry \fISave values\fP the current usage values can
be saved into a file. The format of the file is:
.nf
    # Maximum:
    integer
    # PEs in use follow this line
    integer
    integer
    ...
.fi
Lines starting with \fB#\fP are comment lines. The first non-comment
line specifies the total number of prozessors within this configuration,
all other lines specify the number of active prozessors through the
steps done so far.
.IP "\fBprint VECTOR\fP"
Pop up a window with a graphical display of the current content for a
vector variable. Currently only grids and lists are supported for
processor configurations. All other configurations will be mapped to
one of these. When clicking in the command widget on top of the
window, a menu will pop up with various selections.
.IP "\fBdisp VECTOR\fP"
Will pop up the same window as for \fBprint VECTOR\fP, except that the
displayed variable will be refreshed automatically each time execution
is stopped.

.LP
.SS "Displaying C Data Structures
\fIXp3gdb\fP provides some primitive support for graphically displaying C
structures and the ability of following pointers.  Pressing the RIGHT
mouse button on the \fBprint\fP (or \fBprint *\fP) command button
displays the value of the selected expression (or the value the
selected expression is pointing to) in a popup.  If the value is a
pointer or a structure containing pointers, the user can examine the
value of the object that pointer is pointing to by clicking the pointer
value.  This will create another popup that displays the object the
pointer points to.  Clicking the label of the popup pops down itself
and all of its descendants.
.SH X DEFAULTS
To change the default values of widget resources used in \fIxp3gdb\fP,
you need to reference the widgets by name or by class.  The widget
hierarchies for the main window, the file menu, the search dialog box,
and the popup data display used in xp3gdb are shown as follows, with the
name of the widget followed by the name of its class in parentheses:
.nf

Main window:
    toplevel (ToplevelShell)
      vpane (Paned)
	fileWindow (Form)
	  fileLabel (Label)
	  lineLabel (Label)
	sourceForm (Form)
	  sourceWindow (AsciiText)
	messageWindow (Label)
	commandWindow (Box)
	  run (Command)
	  cont (Command)
	  next (Command)
	  step (Command)
	  finish (Command)
	  break (Command)
	  tbreak (Command)
	  delete (Command)
	  up (Command)
	  down (Command)
	  print (Command)
	  print * (Command)
	  display (Command)
	  undisplay (Command)
	  args (Command)
	  locals (Command)
	  stack (Command)
	  search (Command)
	  file (Command)
	  show display (Command)
	  show brkpts (Command)
	  yes (Command)
	  no (Command)
	  quit (Command)
	dialogWindow (AsciiText)
	displayWindow (AsciiText)

File menu:
    File Directory (TransientShell)
      popup (Paned)
	fileMenuLabel (Label)
	fileMenu (List)
	cancelButton (Command)

Search dialog box:
    Search (TransientShell)
      searchPopup (Dialog)
	<< (Command)
	>> (Command)
	DONE (Command)

Data display popup:
    Data Popup (TransientShell)
      popup (Form)
	label (Label)
	dataDpyWindow (AsciiText)
.LP
.fi
In addition to the standard X resources, \fIxp3gdb\fP uses the following
application-specific resources for user customization.  The value in
parentheses is the default value.
.IP \fBbell\fP
If True, the bell is on. (True)
.IP \fBdisplayWindow\fP
If True, the display window appears on start up. (False)
.IP \fBdelimiters\fP
The set of delimiters for word selection. (" !%^&*()+=~|;:{},/#<?\"\n\t")
.IP \fBstop_color\fP
Color of the stop sign. (Red)
.IP \fBarrow_color\fP
Color of the arrow sign. (Blue)
.IP \fBupdown_color\fP
Color of the updown sign. (Blue)
.IP \fBbomb_color\fP
Color of the bomb sign. (Red)
.IP \fBdataDpyMaxHeight\fP
Maximum height of the data display window. (300)
.IP \fBdataDpyMaxWidth\fP
Maximum width of the data display window. (600)
.IP \fBprompt\fP
The prompt string used in xp3gdb. ("(xp3gdb) ")
.IP \fBdb_name\fP
The name of the debugger program. ("gdb")
.IP \fBdb_prompt\fP
The prompt string of the debugger program. ("(gdb) ")
.IP \fBgdbinit\fP
The filename of initial command file. (".gdbinit")
.IP \fBnx\fP
If True, xp3gdb will not execute .gdbinit at start-up. (False)
.IP \fBcolorScheme\fP
When set to \fIgray\fP or \fIgrey\fP, xp3gdb will not use a color
mapping table on color displays, but will use a gray mapping table
instead. 
.LP

.SH FILES
.nf
a.out 		default object file
core 		default core file
~/XDbx		resources file (or /usr/lib/X11/app-defaults/XDbx)
\&.gdbinit 		local initial commands file
~/.gdbinit 	user's initial commands file
.SH SEE ALSO
X(1), gdb(1), xxgdb(1)
.SH COPYRIGHT
Copyright 1989 The University of Texas at Austin.
Copyright 1990 Microelectronics and Computer Technology Corporation.
Copyright 1990-1993 Thomson Consumer Electronics, Inc.
Copyright 1995,1996 University of Stuttgart, Department of Computer Science.
.SH AUTHOR
Po Cheung.
Pierre Willard.
Joerg Stippa.

