MODULE fractal;
CONST  maxlevel = 7;
       low_val  = 0.0;
       high_val = 1.0;
       maxnode  = 2**maxlevel - 1;

(* specification of binary tree-structure *)
CONFIGURATION tree [1..maxnode];
CONNECTION    child_l : tree[i] <-> tree[2*i]   :parent;
              child_r : tree[i] <-> tree[2*i+1] :parent;

VAR i,j         : INTEGER;
    delta       : REAL;
    field       : ARRAY [1..maxnode] OF REAL;
    x, low, high: tree OF REAL;

PROCEDURE Gauss(): tree OF REAL;
(* random number with Gaussian distribution *)
CONST N  = 4;
      GA = (FLOAT(3*N) ** 0.5);
      GF = 2.0*GA / (FLOAT(N)*FLOAT(MAX(INTEGER)));
VAR i  : INTEGER; 
    sum: tree OF REAL;
BEGIN
  sum:=0.0;
  FOR i:=1 TO N DO sum := sum + FLOAT(ABS(RandomInt(tree))) END;
  RETURN (GF*sum - GA)
END Gauss;

PROCEDURE inorder(node: INTEGER);
BEGIN
  IF node <= maxnode THEN
    inorder(2*node);
      WriteFixPt(field[node], 10,3);
      WriteLn;
    inorder(2*node+1);
  END
END inorder;
 
PROCEDURE MidPoint(delta: REAL; level: INTEGER);
BEGIN
  IF 2**(level-1) <= ID(tree) <=  2**level - 1 THEN (* select tree level *)
    x := 0.5 * (low + high) + delta*Gauss();
    IF level < maxlevel THEN
      SEND.child_l(low,low); (* values for children *)
      SEND.child_l(x,high);
      SEND.child_r(x,low);
      SEND.child_r(high,high);
    END;
  END;
END MidPoint;

BEGIN (* main *)
  low  := low_val;   (* starting values *)
  high := high_val;
  x    := 0.0;
  FOR i:=1 TO maxlevel DO
    delta := 0.5 ** (FLOAT(i)/2.0);
    MidPoint(delta,i);
  END;
  STORE(x,field);
  WriteFixPt(low_val,  10,3); WriteLn;
  inorder(1); (* print displaced values in linear order *)
  WriteFixPt(high_val, 10,3); WriteLn;
END fractal.

