MODULE matrix;
(* compute the matrix product using systolic array technique *)
CONST max = 10;

CONFIGURATION  grid [0..max-1],[0..max-1];
CONNECTION     left:   grid[i,j]  ->  grid[i,(j-1) MOD max];
               up:     grid[i,j]  ->  grid[(i-1) MOD max,j];
               shiftA: grid[i,j]  ->  grid[i,(j-i) MOD max];
               shiftB: grid[i,j]  ->  grid[(i-j) MOD max,j];

VAR i,j  : INTEGER;
    a,b,c: grid OF REAL;

PROCEDURE matrix_mult(VAR a,b,c : grid OF REAL);
VAR k: INTEGER;  (* c := a * b *)
BEGIN
  a := MOVE.shiftA(a);
  b := MOVE.shiftB(b);
  c := a * b;
  FOR k := 2 TO max DO
    a := MOVE.left(a);
    b := MOVE.up  (b);
    c := c + a * b;
  END;
END matrix_mult;

BEGIN
  (* preset input matrices "a" and "b" (or read from file) *)
  a := FLOAT(DIM(grid,2) * 10 + DIM(grid,1));  WriteFixPt(a,7,1);
  b := FLOAT(DIM(grid,2)      + DIM(grid,1));  WriteFixPt(b,7,1);

  matrix_mult(a,b,c);  WriteFixPt(c,7,1);
END matrix.

