MODULE pi;
(* parallel reference algorithm, used by R. Babb *)
CONST intervalls = 100;
      width      = 1.0 / FLOAT(intervalls);
CONFIGURATION list [1..intervalls];
CONNECTION (* none *);

VAR val: list OF REAL;

PROCEDURE f (x: list OF REAL): list OF REAL;
(* function to be integrated *)
BEGIN
  RETURN(4.0 / (1.0 + x*x))
END f;

BEGIN (* integral approximation with rectangle-rule *)
  val := width * f( (FLOAT(ID(list))-0.5) * width );
  WriteReal(REDUCE.SUM(val), 15); WriteLn;
END pi.

