MODULE rot;
(* image rotation *)
CONST   m_size = 8;
CONFIGURATION  pic [0..m_size-1],[0..m_size-1];
CONNECTION     right :  pic [i, j]  <->  pic [i, j+1] :left;
               up    :  pic [i, j]  <->  pic [i+1, j] :down;

TYPE image = ARRAY [0..m_size-1],[0..m_size-1] OF INTEGER;

VAR picture           : image;
    size, i, j        : INTEGER;
    vpic, buffer, x, y: pic OF INTEGER;

PROCEDURE print(p: image; par_size: INTEGER);
VAR i,j: INTEGER;
BEGIN
  WriteLn;
  WriteString("IMAGE partition size ");
  WriteInt(par_size,1); WriteLn;
  FOR i:=m_size-1 TO 0 BY -1 DO
    FOR j:=0 TO m_size-1 DO
      WriteInt(p[i,j],2)
    END;
    WriteLn;
  END;
END print;


BEGIN  (* main *)
  size := m_size;
  FOR i:=0 TO m_size-1 DO  (* create test pattern *)
    FOR j:=0 TO m_size-1 DO
      picture[i,j] := 0
    END;
  END;
  FOR i:=0 TO m_size-1 DO 
    picture[i,i] := 1;
  END;
  FOR i:=1 TO 5 DO
    picture[0,i] := 1;
    picture[i,0] := 1;
  END;

  print(picture, m_size);  (* print original image *)
  LOAD(vpic, picture);

  WHILE size > 1 DO
    x := DIM(pic,1) MOD size;
    y := DIM(pic,2) MOD size;
    size := size DIV 2;

    IF x < size THEN
      IF y < size THEN SEND.up   :size (vpic,buffer)  (* bottom left  *)
                  ELSE SEND.right:size (vpic,buffer)  (* top left     *)
      END
     ELSE (* x >= size2 *)
      IF y < size THEN SEND.left :size (vpic,buffer)  (* bottom right *)
                  ELSE SEND.down :size (vpic,buffer)  (* top right    *)
      END
    END;

    vpic := buffer;  (* copy new value *)

    STORE(vpic, picture);
    print(picture, size);
  END; (* while *)

END rot.

