MODULE epdg1test;
(* Beispielanwendung fuer CR (zyklische Reduktion) *)

FROM pdiff1 IMPORT epdg1,Coeff1, Coeff2, ppdg1;

VAR h,tau     : REAL;
     n, t     : CARDINAL;
s,r,p,q,randl, anf: Coeff1;

PROCEDURE P(x:REAL):REAL;
BEGIN
 RETURN 1.0;
END P;

PROCEDURE Q(x:REAL):REAL;
BEGIN
 RETURN (x-2.);
END Q;

PROCEDURE R(x:REAL):REAL;
BEGIN
 RETURN -3.;
END R;

PROCEDURE rn(x:REAL):REAL;
BEGIN
 IF (x<=0.) OR (x>=REAL(n-1)*tau) THEN RETURN 5.;
 END;
 RETURN 0.;
END rn;

PROCEDURE S(x:REAL):REAL;
BEGIN
 RETURN 0.;
END S;

BEGIN
 tau  := 0.5;
 r    := R;
 s    := S;
 p    := P;
 q    := Q;

 anf  := rn; (* Anfangsbedingung *)

 WriteString(" #Stuetzpunkte : "); ReadCard(n);
 WriteString(" #Rechenschritte : "); ReadCard(t);

 h := 4./FLOAT(n-1);

 epdg1(n, t, 0., h, p, q, r, s, anf, 1, "mydir/crtest");

END epdg1test.
