IMPLEMENTATION MODULE gnuout1;
(* convert data into gnuplot file format       
   author  . Beate Sonntag                     
   language. Parallaxis-III                   
   last update . Mon May 15 13:33:34 MET DST 1995  
 *)

FROM str IMPORT strlen, Concat, Convert;

VAR ymax, ymin : INTEGER;

PROCEDURE WritePlotfile(prefix : ARRAY OF CHAR;
                           n,y : CARDINAL;
                         array : ARRAY OF REAL;
                         x0,hx : REAL);
VAR i        : CARDINAL;
    filename : ARRAY[0..20] OF CHAR;
    postfix  : ARRAY[0..5] OF CHAR;
    x        : REAL;
BEGIN
 Convert(n,postfix);
 Concat(prefix,postfix,filename);
 OpenOutput(filename);
 WriteString("#  X            Y"); WriteLn;
 x := x0;
 FOR i:=0 TO y-1 DO
     WriteReal(x,8); WriteString("   "); WriteReal(array[i],8); WriteLn;
     x := x + hx;
     IF ceiling(array[i]) > ymax THEN ymax := ceiling(array[i]);
     ELSIF floor(array[i]) < ymin THEN ymin := floor(array[i]);END;
 END;
 CloseOutput;
END WritePlotfile;

PROCEDURE WriteCommandfile( prefix : ARRAY OF CHAR; 
                                 n : CARDINAL);
VAR    line : ARRAY[0..255] OF CHAR;
    postfix : ARRAY[0..5] OF CHAR;
   filename : ARRAY[0..20] OF CHAR;
          f : INTEGER;
BEGIN
  OpenOutput("command");

  Convert(ymin,postfix);    (* set yrange[ymin:ymax] *)
  Concat("set yrange[",postfix,line);
  Concat(line,":",line);
  Convert(ymax,postfix);
  Concat(line,postfix,line);
  Concat(line,"]",line);
  WriteString(line);WriteLn; 

  WriteString("set format xy '%.2f'"); WriteLn; 

  Convert(1,postfix);    (* plot filename1 with lines *)
  Concat(prefix,postfix,filename);
  Concat("plot '",filename,line);
  Concat(line,"' with lines",line);
  WriteString(line); WriteLn;

  WriteString("pause -1"); WriteLn;

  FOR f:= 1 TO n DO
   Convert(f,postfix);
   Concat(prefix,postfix,filename);
   Concat("plot '",filename,line);
   Concat(line,"' with lines",line);
   WriteString(line);WriteLn; 
  END;
  WriteString("pause -1"); WriteLn;

  CloseOutput;
END WriteCommandfile;

PROCEDURE InitMaxMin( max , min : INTEGER);
BEGIN
 IF min > max THEN WriteString(" InitMaxMin : min > max !"); WriteLn;
 ELSE ymax := max; ymin := min;
 END;
END InitMaxMin;

BEGIN
 InitMaxMin(0,0);
END gnuout1.

