IMPLEMENTATION MODULE pdiff1;
(* methods for onedimensional linear partial differential equations 
 * author  . Beate Sonntag
 * language. Parallaxis-III V0.3
 * bugs    . not fully tested
 * last update . Thu Feb  9 10:38:15 MET 1995
 *)

FROM gnuout1 IMPORT  WritePlotfile, WriteCommandfile;

CONFIGURATION Open[*];

CONST maxplotnumber = 65532; (* max. number of values to plot... *)

(* Cyclic Reduction Algorithm 
 * for one-dimensional linear parabolic partial differential equations
 * last update : Thu Feb  2 16:21:15 MET 1995
 *)
PROCEDURE cyclic(n,timesteps                 : CARDINAL; 
                 x1,hx,tau                   : REAL;
             VAR CR_Pij,CR_Qij,CR_Rij,
                 CR_Sij,CR_Bound             : Coeff2;
             VAR CR_InitCond                 : Coeff1;
                 output                      : CARDINAL;
                 filename                    : ARRAY OF CHAR);

CONFIGURATION Line = Open[0..n-1];

CONNECTION FOR k := 1 TO ceiling( (ln(REAL(n-2))/ln(2.)) ) DO
              left[k] : Line[i] -> Line[i-(2**(k-1))],
                           {i=n-1} Line[n-(2**(k-1))..n-2];
              right[k] : Line[i] -> Line[i+(2**(k-1))],
                              {i=0} Line[1..2**(k-1)-1];
           END;

VAR             Rek : Line OF ARRAY[0..6] OF REAL;
  k, log2n, N, Time : INTEGER;

  PROCEDURE InitCoeff(VAR a,b,c,d : Line OF REAL; 
                                u : Line OF REAL; 
                             x0,t : REAL);
  VAR alpha, beta, ri : REAL;
                    i : INTEGER;
  BEGIN
    alpha := tau/hx/hx;
    beta  := tau/2./hx; 
  
    IF DIM(Line,1)=1 THEN
      b := -(1.0 -tau*CR_Rij(x0+hx,t) +2.*alpha * CR_Pij(x0+hx,t));
      c := alpha * CR_Pij(x0+hx,t) + beta * CR_Qij(x0+hx,t);
      d := -(u + tau * CR_Sij(x0+hx,t) 
          +(alpha * CR_Pij(x0+hx,t) -beta * CR_Qij(x0+hx,t))*CR_Bound(x0,t));
    END;
  
    FOR i:= 2 TO n-1 DO
     ri := REAL(i);
     IF DIM(Line,1)=i THEN
      a := alpha * CR_Pij(x0+ri*hx,t) - beta * CR_Qij(x0+ri*hx,t);
      b := -(1.0 -tau*CR_Rij(x0+ri*hx,t) +2.*alpha * CR_Pij(x0+ri*hx,t));
      c := alpha * CR_Pij(x0+ri*hx,t) + beta * CR_Qij(x0+ri*hx,t);
      d := -(tau * CR_Sij(x0+ri*hx,t) + u);
     END;
    END;
  
    IF DIM(Line,1)=n THEN
      ri := REAL(n);
      a := alpha * CR_Pij(x0+ri*hx,t) -beta * CR_Qij(x0+ri*hx,t);
      b := -(1.0 -tau*CR_Rij(x0+ri*hx,t) +2.*alpha * CR_Pij(x0+ri*hx,t));
      d := -(u + tau * CR_Sij(x0+ri*hx,t)  
               +(alpha * CR_Pij(x0+ri*hx,t) +beta * CR_Qij(x0+ri*hx,t))
                 *CR_Bound(x0+REAL(n+1)*hx,t));
    END;
  
  END InitCoeff;

  PROCEDURE WriteOut(This: Line OF REAL; x0,hx:REAL; how:CARDINAL);
  VAR arr : ARRAY[0..maxplotnumber] OF REAL;
  BEGIN
  CASE how OF
  |0 : WriteFixPt(This,6,3);WriteLn;
  ELSE
       STORE(This,arr);
       WritePlotfile(filename,how,N+1,arr,x0,hx);
  END;
  END WriteOut;


BEGIN (*cyclic*)

 IF (output=1) AND (n>maxplotnumber) THEN 
    WriteString("pdiff1 overflow error :  output set to stdout ");
    output := 0;
 END;

 IF ((output=0) AND (filename[0]<>0C)) THEN OpenOutput(filename); 
 END;

 n := n-2;
 log2n := ceiling( (ln(REAL(n))/ln(2.)) ) ;
 N := n+1; 

 FOR k:=1 TO n DO   (* Initial Condition *)
  IF DIM(Line,1)=k THEN
     Rek[0] := CR_InitCond(x1+REAL(k)*hx); 
  END;
 END;
 IF DIM(Line,1)=0 THEN (* Boundary Condition *)
    Rek[0] :=CR_Bound(x1,0.);
 END;
 IF DIM(Line,1)=N THEN
    Rek[0] := CR_Bound(x1+hx*REAL(N),0.);
 END;

 WriteOut(Rek[0],x1,hx,output*1);

 Rek[1] := 0.0;  (* Init *) 
 Rek[2] := 1.0;
 Rek[3] := 0.0;
 Rek[4] := 0.0;

 FOR Time := 1 TO timesteps DO 
   InitCoeff(Rek[1],Rek[2],Rek[3],Rek[4],Rek[0],x1,REAL(Time)*tau);
 
   FOR k:= 1 TO log2n DO
     IF (0<DIM(Line,1)<N) THEN
 
       Rek[5] := -Rek[1] / RECEIVE.right[k](Rek[2]);     (* alpha *)
       Rek[6] := -Rek[3] / RECEIVE.left[k](Rek[2]);      (* gamma  *)
       Rek[2] := Rek[5] * RECEIVE.right[k](Rek[3]) + Rek[2] 
               + Rek[6] * RECEIVE.left[k](Rek[1]);       (* b *)
       Rek[1] := Rek[5] * RECEIVE.right[k](Rek[1]);      (* a *)
       Rek[3] := Rek[6] * RECEIVE.left[k](Rek[3]);       (* c *)
       Rek[4] := Rek[5] * RECEIVE.right[k](Rek[4]) + Rek[4] 
               + Rek[6] * RECEIVE.left[k](Rek[4]);       (* d *)
     END;
   END; 
 
   IF (0<DIM(Line,1)<N) THEN
     Rek[0] := Rek[4] / Rek[2]; (* x *)
   END; 

   (* set boundary values for output *)
   IF DIM(Line,1)=0 THEN
     Rek[0] := CR_Bound(x1,REAL(Time)*tau); 
   END;
   IF DIM(Line,1)=N THEN
     Rek[0] := CR_Bound(x1+hx*REAL(N),REAL(Time)*tau); 
   END;

   WriteOut(Rek[0],x1,hx,output*(Time+1));

 END; (*FOR*) 

 IF (output<>0) THEN 
   WriteCommandfile( filename, (timesteps+1)); 
 ELSE CloseOutput;
 END;

END cyclic;


(* elliptic pdes explcit formula *)
PROCEDURE epdg1(X,it          : CARDINAL; 
                x1,hx         : REAL; 
         VAR PK,QK,RK,SK,init : Coeff1;
                output        : CARDINAL;
                filename      : ARRAY OF CHAR);

CONFIGURATION Line = Open[1..X];

CONNECTION  West : Line[xi] <-> Line[xi+1] : East;
               
VAR  Res,P,Q,R,S,k1,k2,k4: Line OF REAL;
     Step,i,k : INTEGER; 
     hx2, alpha,beta:REAL;

  PROCEDURE Result( Res,k1,k2,k3,k4: Line OF REAL):Line OF REAL;
  BEGIN
   IF (1<DIM(Line,1)<X) THEN (* nur innere Punkte berechnen *)
      Res := ( ( k2*RECEIVE.West(Res)  + 
              k1*RECEIVE.East(Res) +k3)/k4);
   END;
   RETURN  Res;
  END Result;

  PROCEDURE SetInit(VAR This : Line OF REAL; VAR F: Coeff1);
  (* set initial and boundary condition *)
  VAR i,k : CARDINAL; 
  BEGIN
    FOR i:=1 TO X DO
      IF (DIM(Line,1)=i) THEN
        This := F(x1+REAL(i-1)*hx);
      END;
    END;
  END SetInit;

  PROCEDURE WriteOut(This: Line OF REAL; x0, hx:REAL; how:CARDINAL);
  VAR arr : ARRAY[0..maxplotnumber] OF REAL;
  BEGIN
  CASE how OF
  |0 : WriteFixPt(This,6,3);WriteLn;
  ELSE
   STORE(This,arr);
   WritePlotfile(filename,how,X,arr,x0,hx);
  END;
  END WriteOut;

BEGIN 

 IF (output=1) AND (X>maxplotnumber) THEN 
    WriteString("pdiff1 overflow error :  output set to stdout ");
    output := 0;
 END;

 IF ((output=0) AND (filename[0]<>0C)) THEN OpenOutput(filename); 
 END;

 FOR i:= 2 TO X-1 DO
   IF (DIM(Line,1)=i) THEN
     P := PK(REAL(i-1)*hx+x1); 
     Q := QK(REAL(i-1)*hx+x1);
     S := SK(REAL(i-1)*hx+x1);
     R := RK(REAL(i-1)*hx+x1);
   END;
 END;

 hx2:= hx*hx; 
 alpha := 1./hx2;
 beta  := 1./2./hx;

 k1:= alpha*P + beta*Q; 
 k2:= alpha*P - beta*Q;
 k4:= 2.*alpha*P - R;

 SetInit(Res,init);   

 WriteOut(Res,x1,hx,output*1);

 FOR Step := 1 TO it DO
   Res := Result(Res,k1,k2,S,k4);
 END;

 WriteOut(Res,x1,hx,output*2);

 IF output <> 0 THEN WriteCommandfile(filename,2);
 ELSE CloseOutput;
 END;
END epdg1;


(* parabolic pdes explicit formula *)
PROCEDURE ppdg1 ( n, timesteps              : CARDINAL; 
                  x1, hx, tau               : REAL;
              VAR Pij, Qij, Rij, Sij, bound : Coeff2;
              VAR init                      : Coeff1;
                  output                    : CARDINAL;
                  filename                  : ARRAY OF CHAR );

CONFIGURATION Line = Open[1..n];

CONNECTION west : Line[xi] <-> Line[xi+1] : east;

VAR   Res,p,q,r,s,K1,K2,K3 : Line OF REAL;
                  i,Time   : CARDINAL;
             xk,alpha,beta : REAL;

  PROCEDURE WriteOut(This: Line OF REAL; x0, hx:REAL; how:CARDINAL);
  VAR arr : ARRAY[0..maxplotnumber] OF REAL;
  BEGIN
  CASE how OF
  |0 : WriteFixPt(This,6,3);WriteLn;
  ELSE
   STORE(This,arr);
   WritePlotfile(filename,how,n,arr,x0,hx);
  END;
  END WriteOut;

BEGIN
 IF (output=1) AND (n>maxplotnumber) THEN 
    WriteString("pdiff1 overflow error :  output set to stdout ");
    output := 0;
 END;

 IF ((output=0) AND (filename[0]<>0C)) THEN OpenOutput(filename); 
 END;

 (* initial and boundary conditions*)
 FOR i:=2 TO n-1 DO
   xk:= REAL(i); 
   IF ID(Res)=i THEN 
     Res := init(x1+(xk-1.)*hx); 
   END;
 END;
 IF ID(Line)=1 THEN 
    Res := bound(x1,0.); 
 END;
 IF ID(Line)=n THEN 
    Res := bound(REAL(n-1)*hx+x1,0.); 
 END;

 alpha := tau/hx/hx;
 beta  := tau/2./hx ;

 WriteOut(Res,x1,hx,output*1);

 FOR Time := 0 TO timesteps-1 DO 
   FOR i:=2 TO n-1 DO (* new coefficients for each timestep *)
     xk:= REAL(i); 
     IF (ID(Line)=i) THEN 
       p := Pij(x1+(xk-1.)*hx, REAL(Time)*tau);
       q := Qij(x1+(xk-1.)*hx, REAL(Time)*tau);
       r := Rij(x1+(xk-1.)*hx, REAL(Time)*tau);
       s := Sij(x1+(xk-1.)*hx, REAL(Time)*tau);
     END;
   END;
   (*  new boundary condition *) 
   IF (ID(Line)=1) THEN 
      Res := bound(x1, REAL(Time)*tau); 
   END;
   IF (ID(Line)=n) THEN 
      Res := bound(REAL(n-1)*hx+x1, REAL(Time)*tau); 
   END;

   K1 := alpha*p - beta*q;
   K2 := 1.+ tau*r -2.*alpha*p;
   K3 := alpha*p + beta*q;

   IF (1<ID(Line)<n) THEN (* innere Punkte berechnen *) 
     Res :=  K1*RECEIVE.west(Res) + K2*Res 
           + K3*RECEIVE.east(Res) + tau*s;
   END;

   WriteOut(Res,x1,hx,output*(Time+2));
 END;

 IF output <> 0 THEN WriteCommandfile(filename,timesteps+1);
 ELSE CloseOutput;
 END;
END ppdg1;


BEGIN
END pdiff1.
