MODULE ppdg1test;
(* Beispielanwendung fuer ppdg1 *)

FROM pdiff1 IMPORT Coeff1, Coeff2, ppdg1;

VAR h,tau     : REAL;
     n, t     : CARDINAL;
s,r,p,q,randl : Coeff2;
           anf: Coeff1;

PROCEDURE P(x,t:REAL):REAL;
BEGIN
 RETURN 1.0;
END P;

PROCEDURE Q(x,t:REAL):REAL;
BEGIN
 RETURN (x-2.);
END Q;

PROCEDURE R(x,t:REAL):REAL;
BEGIN
 RETURN -3.;
END R;

PROCEDURE an(x:REAL):REAL;
BEGIN
 RETURN x*x - 4.*x +5.;
END an;

PROCEDURE rn(x,t:REAL):REAL;
BEGIN
 RETURN 5.*exp(-t);
END rn;

PROCEDURE S(x,t:REAL):REAL;
BEGIN
 RETURN 0.;
END S;

BEGIN
 tau  := 0.05;
 r    := R;
 s    := S;
 p    := P;
 q    := Q;

 anf  := an; (* Anfangsbedingung *)
 randl := rn; (* Randbedingung *)

 WriteString(" #Stuetzpunkte : "); ReadCard(n);
 WriteString(" #Zeitschritte : "); ReadCard(t);

 h := 4./FLOAT(n-1);

 ppdg1(n, t, 0., h, tau, p, q, r, s, randl, anf, 1, "mydir/ppdg1test");

END ppdg1test.
