MODULE epdg2test2;

FROM pdiff2 IMPORT epdg2, Coeff2;

VAR p1,p2,q1,q2,rk,sk,f : Coeff2; (* Prozedurvariable *)
  X, Y, it        : CARDINAL;
  X1, Y1, hx, hy  : REAL;


PROCEDURE P1(x,y:REAL):REAL;
BEGIN                       RETURN 1.;
END P1;

PROCEDURE PK(x,y:REAL):REAL;
BEGIN                       RETURN -y;
END PK;

PROCEDURE QK(x,y:REAL):REAL;
BEGIN                       RETURN -x;
END QK;

PROCEDURE SK(x,y:REAL):REAL;
BEGIN                       RETURN 0.;
END SK;

PROCEDURE F(x,y:REAL):REAL;
BEGIN
 IF (((x<=X1) OR (x>=X1+hx*REAL(X-1)))OR
    ((y<=Y1) OR (y>=Y1+hy*REAL(Y-1)))) THEN
    RETURN (x-y);
 END;
 RETURN 0.;
END F;

BEGIN
  p1 := P1;   p2 := P1;
  q1 := PK;   q2 := QK;   
  rk := SK;   sk := SK;   f := F;

  X  := 5;     Y := 4;    it := 15;
  X1 := 0.0;  Y1 := 0.0;
  hx := 0.5;  hy := 0.5;

 epdg2(X,Y,it,X1,hx,Y1,hy,p1,p2,q1,q2,rk,sk,f,1,"mydir/test");

END epdg2test2.
