IMPLEMENTATION MODULE gnuout2;

FROM str IMPORT strlen, Concat, Convert;

VAR max, min:INTEGER;

PROCEDURE WritePlotfile(prefix : ARRAY OF CHAR;n,x,y:CARDINAL;
                            Feld:ARRAY OF REAL;
                        x0,hx,y0,hy :REAL);
(* x ist in CONF. zweite Dimension : [1..x],[1..y] *)
VAR i,j: INTEGER;
    filename : ARRAY[0..20] OF CHAR;
    postfix : ARRAY[0..5] OF CHAR;
    xc, yc :REAL;
BEGIN
 Convert(n,postfix);
 Concat(prefix,postfix,filename);
 OpenOutput(filename);

(* WriteString("#  X       Y          Z");WriteLn; *)

 xc := x0;
 yc := y0;

 FOR i:=0 TO y-1 DO
   FOR j := 0 TO x-1 DO
(*     WriteReal(xc,8);WriteString("   ");
     WriteReal(yc,8);WriteString("   ");
*)     WriteFixPt(Feld[j*y+i],6,3);WriteLn;
     xc := xc+hx;
     IF ceiling(Feld[j*y+i]) > max THEN max := ceiling(Feld[j*y+i]);END;
     IF floor(Feld[j*y+i]) < min THEN min := floor(Feld[j*y+i]);END;
   END;
   yc := yc+hy;
   xc := x0;
   WriteLn;
 END;

 CloseOutput;
END WritePlotfile;

PROCEDURE WriteCommandfile( prefix : ARRAY OF CHAR; 
                                 n : CARDINAL);
VAR    line : ARRAY[0..255] OF CHAR;
    postfix : ARRAY[0..5] OF CHAR;
    filename : ARRAY[0..20] OF CHAR;
          f : INTEGER;
BEGIN
  OpenOutput("command");

  Convert(min,postfix);    (* set yrange[min:max] *)
  Concat("set zrange[",postfix,line);
  Convert(max,postfix);
  Concat(line,":",line);
  Concat(line,postfix,line);
  Concat(line,"]",line);
  WriteString(line);WriteLn; 

  WriteString("set format xy '%.2f'");WriteLn;

  Convert(1,postfix);    (* plot filename1 with lines *)
  Concat(prefix,postfix,filename);
  Concat("splot '",filename,line);
  Concat(line,"' with lines",line);
  WriteString(line); WriteLn;

  WriteString("pause -1"); WriteLn;

  FOR f:= 1 TO n DO
   Convert(f,postfix);
   Concat(prefix,postfix,filename);
   Concat("splot '",filename,line);
   Concat(line,"' with lines",line);
   WriteString(line);WriteLn; 
  END;
  WriteString("pause -1");
  WriteLn;
  CloseOutput;
END WriteCommandfile;

BEGIN
 max :=0; min :=0;
END gnuout2.

