IMPLEMENTATION MODULE pdiff2;
(* methods for twodimensional linear pdes 
 * author  . Beate Sonntag
 * language. Parallaxis-III V0.3
 * bugs    . not fully tested
 * last update . Thu Feb  9 10:38:15 MET 1995
 *)


FROM gnuout2 IMPORT WritePlotfile, WriteCommandfile;

CONFIGURATION Open[*],[*];

CONST maxplotnumber = 65534;

(* twodimensional parabolic pde's explicit formula *) 
PROCEDURE ppdg2 (x, y, timesteps            : CARDINAL;
                 x1, hx, y1, hy, tau        : REAL;
            VAR  P1, P2, Q1, Q2, R, S,bound : Coeff3;
            VAR  init                       : Coeff2;
                 output                     : CARDINAL;
                 filename                   : ARRAY OF CHAR);

CONFIGURATION grid=Open[1..y],[1..x]; 
CONNECTION 
west2 : grid[yi,xi] <-> grid[yi+1,xi] : east2;
south2: grid[yi,xi] <-> grid[yi,xi+1] : north2;

VAR Para,p1,p2,q1,q2,r,s,
    K1,K2,K3,K4,K5,K6 : grid OF REAL;
    i, k, j           : CARDINAL;
    alpha1, alpha2, beta1, beta2, 
    xk, yk            : REAL;

 PROCEDURE Result(Source,K1,K2,K3,K4,K5,K6: grid OF REAL):grid OF REAL;
 BEGIN
  IF ((1 < DIM(grid,1) < x) AND
      (1 < DIM(grid,2) < y)) THEN  
    Source := ( K4*RECEIVE.west2(Source) 
             +K2*RECEIVE.south2(Source)
             +K3*RECEIVE.east2(Source)
             +K1*RECEIVE.north2(Source) +K5*Source + K6 );
  END;
  RETURN Source;
 END Result;


 PROCEDURE WriteOut(Source : grid OF REAL; x0,hx,y0,hy : REAL;how : INTEGER);
 VAR arr : ARRAY[1..maxplotnumber] OF REAL;
 BEGIN
  CASE how OF
  | 0: WriteFixPt(Source,6,3);
  ELSE
     STORE(Source, arr);
     WritePlotfile(filename,how,y,x,arr,x0,hx,y0,hy);
  END;
 END WriteOut;


BEGIN
 IF (output=1) THEN
  IF (x*y>maxplotnumber) THEN
   WriteString("pdiff2 overflow error : output set to stdout");
   output := 0;
  END;
  IF (filename[0]=0C) THEN
   output := 0;
  END;
 ELSIF ((output=0) AND (filename[0]<>0C)) THEN 
   OpenOutput(filename);
 END;
 
 (* initial and boundary condition *)
 FOR i:=1 TO x DO
   xk:= REAL(i);
   FOR j:=1 TO y DO
     yk:= REAL(j);
     IF ((DIM(Para,1)=i) AND (DIM(Para,2)=j)) THEN 
         IF ((i=1) OR (j=1) OR (i=x) OR (j=y) )THEN
           Para := bound(x1+(xk-1.)*hx,y1+(yk-1.)*hy,0.); 
         ELSE
           Para := init(x1+(xk-1.)*hx,y1+(yk-1.)*hy);
         END;
     END;
   END;
 END;

 WriteOut(Para,x1,hx,y1,hy,output*1);

 alpha1 := tau/hx/hx;
 alpha2 := tau/hy/hy;
 beta1  := tau/2./hx;
 beta2  := tau/2./hy;

 FOR k := 1 TO timesteps DO
   FOR i:=1 TO x DO
     xk:= REAL(i); 
     FOR j:=1 TO y DO
       yk:= REAL(j);
       IF ((DIM(grid,1)=i) AND (DIM(grid,2)=j)) THEN 
         IF ((i=1) OR (j=1) OR (i=x) OR (j=y) )THEN
           Para := bound(x1+(xk-1.)*hx,y1+(yk-1.)*hy,REAL(k-1)*tau); 
         ELSE
           p1 := P1(x1+(xk-1.)*hx, y1+(yk-1.)*hy, REAL(k-1)*tau);
           p2 := P2(x1+(xk-1.)*hx, y1+(yk-1.)*hy, REAL(k-1)*tau);
           q1 := Q1(x1+(xk-1.)*hx, y1+(yk-1.)*hy, REAL(k-1)*tau);
           q2 := Q2(x1+(xk-1.)*hx, y1+(yk-1.)*hy, REAL(k-1)*tau);
           r  := R(x1+(xk-1.)*hx, y1+(yk-1.)*hy, REAL(k-1)*tau);
           s  := S(x1+(xk-1.)*hx, y1+(yk-1.)*hy, REAL(k-1)*tau);
         END;
       END;
     END;
   END;

   K1 := alpha1*p1 + beta1*q1;
   K2 := alpha1*p1 - beta1*q1;
   K3 := alpha2*p2 + beta2*q2;
   K4 := alpha2*p2 - beta2*q2;
   K5 := 1. - 2.*alpha1*p1 - 2.*alpha2*p2 + tau*r;
   K6 := tau*s;

   Para := Result(Para,K1,K2,K3,K4,K5,K6);

   WriteOut(Para,x1,hx,y1,hy,output*(k+1));

 END;

 IF (output<>0) THEN WriteCommandfile(filename,timesteps+1);
 ELSE IF (filename[0]<>0C) THEN CloseOutput; END;
 END;

END ppdg2;


(* twodimensional pde's explicit formula *)
PROCEDURE epdg2(X, Y, it                : CARDINAL; 
                x1, hx, y1, hy          : REAL; 
            VAR PK1,PK2,QK1,QK2,RK,SK,F : Coeff2;
                output                  : CARDINAL;
                filename                : ARRAY OF CHAR);

CONFIGURATION grid=Open[1..Y],[1..X];
CONNECTION 
south  : grid[yi,xi] <-> grid[yi+1,xi] : north;
west   : grid[yi,xi] <-> grid[yi,xi+1] : east;
               
VAR  ellp,P1,P2,Q1,Q2,R,S,k1,k2,k3,k4,k5,k6: grid OF REAL;
     step,i,k : INTEGER; 
     hx2,hy2, alpha1,alpha2,beta1,beta2:REAL;

 PROCEDURE Result( Res,k1,k2,k3,k4,k5,k6: grid OF REAL):grid OF REAL;
 BEGIN
  IF (1<DIM(grid,1)<X) AND
     (1<DIM(grid,2)<Y) THEN  (* nur innere Punkte berechnen *)
     Res := ( ( k2*RECEIVE.west(Res) + k3* RECEIVE.north(Res) + 
             k1*RECEIVE.east(Res) + k4* RECEIVE.south(Res) +k5)/k6);
  END;
  RETURN  Res;
 END Result;


 PROCEDURE SetF(VAR This : grid OF REAL; VAR F: Coeff2);
 (* set initial condition *)
 VAR i,k : CARDINAL; 
 BEGIN
   FOR i:=1 TO X DO
     FOR k:=1 TO Y DO
       IF (DIM(grid,1)=i) AND (DIM(grid,2)=k) THEN
         This := F(x1+REAL(i-1)*hx,y1+REAL(k-1)*hy);
       END;
     END;
   END;
 END SetF;

 PROCEDURE WriteOut(This :  grid OF REAL;x0,hx,y0,hy :REAL; how : CARDINAL);
 VAR arr : ARRAY[1..maxplotnumber] OF REAL;
 BEGIN
  CASE how OF
  | 0: WriteFixPt(This,6,3);
  ELSE
     STORE(This, arr);
     WritePlotfile(filename,how,Y,X,arr,x0,hx,y0,hy);
  END;
 END WriteOut;

BEGIN 
 IF (output=1) THEN
  IF (X*Y>maxplotnumber) THEN
   WriteString("pdiff2 overflow error : output set to stdout");
   output := 0;
  END;
  IF (filename[0]=0C) THEN
   output := 0;
  END;
 ELSIF ((output=0) AND (filename[0]<>0C)) THEN 
   OpenOutput(filename);
 END;

 FOR i:= 1 TO X DO
   FOR k:=1 TO Y DO
     IF (DIM(grid,1)=i) AND (DIM(grid,2)=k) THEN
       P1 := PK1(REAL(i-1)*hx+x1,REAL(k-1)*hy+y1); 
       P2 := PK2(REAL(i-1)*hx+x1,REAL(k-1)*hy+y1); 
       Q1 := QK1(REAL(i-1)*hx+x1,REAL(k-1)*hy+y1);
       Q2 := QK2(REAL(i-1)*hx+x1,REAL(k-1)*hy+y1);
       S  := SK(REAL(i-1)*hx+x1,REAL(k-1)*hy+y1);
       R  := RK(REAL(i-1)*hx+x1,REAL(k-1)*hy+y1);
     END;
   END;
 END;

 hx2:= hx*hx; (* grid gap^2*)
 hy2:= hy*hy;
 alpha1 := 1./hx2;
 alpha2 := 1./hy2;
 beta1  := 1./2./hx;
 beta2  := 1./2./hy;

 k1:= alpha1*P1 + beta1*Q1; (* Koeffizienten fuer explizite Formel *)
 k2:= alpha1*P1 - beta1*Q1;
 k3:= alpha2*P2 + beta2*Q2;
 k4:= alpha2*P2 - beta2*Q2;
 k6:= 2.*alpha1*P1 + 2.*alpha2*P2 - R;

 SetF(ellp,F);   (* Anfangs- und Randbedingung *)

 WriteOut(ellp,x1,hx,y1,hy,output*1);

 FOR step := 1 TO it DO
   ellp := Result(ellp,k1,k2,k3,k4,S,k6);
 END;

 WriteOut(ellp,x1,hx,y1,hy,output*2);

 IF (output<>0) THEN WriteCommandfile(filename,2);
 ELSIF (filename[0] <>0C) THEN CloseOutput;
 END;

END epdg2;

(* Verfahren der alternierenden Richtungen 
 * mit zeitabhaengigen Koeffizienten
 * last update : Thu Feb  2 16:21:15 MET 1995
 *)
PROCEDURE altdir(n, m, T                            : CARDINAL; 
                 x0, hx, y0, hy, tau                : REAL;
             VAR CR_P1ij, CR_P2ij, CR_Q1ij, CR_Q2ij,
                 CR_Rij, CR_Sij, CR_Bound           : Coeff3;
             VAR CR_Init                            : Coeff2;
                 output                             : CARDINAL;
                 filename                           : ARRAY OF CHAR);

CONFIGURATION Line = Open[0..n-1],[0..m-1];

CONNECTION FOR r1 := 1 TO ceiling( (ln(REAL(n-2))/ln(2.)) ) DO
              left[r1] : Line[i,j] -> Line[i-(2**(r1-1)),j],
                           {i=n-1} Line[n-(2**(r1-1))..n-2,j];
              right[r1] : Line[i,j] -> Line[i+(2**(r1-1)),j],
                              {i=0} Line[1..2**(r1-1)-1,j];
           END;
           FOR r2 := 1 TO ceiling( (ln(REAL(m-2))/ln(2.)) ) DO
              up[r2]   : Line[i,j] -> Line[i,j-(2**(r2-1))],
                           {j=m+1} Line[i,m-(2**(r2-1))..m-2];
              down[r2] : Line[i,j] -> Line[i,j+(2**(r2-1))],
                              {j=0} Line[i,1..2**(r2-1)-1];
           END;

VAR Rek : Line OF ARRAY[0..6] OF REAL;
  i,k,l,log2n,log2m,N,M,Time : INTEGER;

 PROCEDURE WriteOut(Source : Line OF REAL;x0,hx,y0,hy : REAL; how : INTEGER);
 VAR arr : ARRAY[1..maxplotnumber] OF REAL;
 BEGIN
  CASE how OF
  | 0: WriteFixPt(Source,6,3);
  ELSE
     STORE(Source, arr);
     WritePlotfile(filename,how,n+2,m+2,arr,x0,hx,y0,hy);
  END;
 END WriteOut;

 PROCEDURE InitKoeff1(VAR a,b,c,d: Line OF REAL; 
                             u : Line OF REAL; 
                   x0,y0,t,tau:REAL;
      VAR    P1ij,P2ij,Q1ij,Q2ij,Rij,Sij,Bound:Coeff3);

 VAR alpha1,alpha2,beta1, beta2,ri,rj,cx,cy,tprev,
     p1,p2,q1,q2,r,s,bound : REAL;
     i,j : INTEGER;
 BEGIN
   tprev := t-tau/2.;
  alpha1 := tau/hx/hx;
  alpha2 := tau/hy/hy;
  beta1  := tau/2./hx;
  beta2  := tau/2./hy;

  IF (DIM(Line,2)=1) THEN
    cx := x0+hx;
    FOR i:= 1 TO m DO
      ri := REAL(i);
      cy := y0+ri*hy;
      p1 :=P1ij(cx,cy,t);
      p2 :=P2ij(cx,cy,tprev);
      q1 :=Q1ij(cx,cy,t);
      q2 :=Q2ij(cx,cy,tprev);
       r :=Rij(cx,cy,tprev);
       s :=Sij(cx,cy,tprev);
      bound :=Bound(x0,cy,t);
      IF (DIM(Line,1)=i) THEN
        b := (1. + 2.*alpha1*p1) ;
        c := (-alpha1 * p1 - beta1 *q1);
        d := bound*(alpha1*p1 - beta1*q1)
             + u*(1. - 2.*alpha2*p2 + tau*r)
             + RECEIVE.down[1](u)*(alpha2*p2 + beta2*q2)
             + RECEIVE.up[1](u)  *(alpha2*p2 - beta2*q2)
             + tau*s;
       END;
     END;
  END;

  FOR i:= 2 TO n-1 DO
    ri := REAL(i);
    cx := x0+ri*hx;
    IF (DIM(Line,2)=i) THEN
      FOR j:= 1 TO m DO
        rj := REAL(j);
        cy := y0+rj*hy;
        p1 :=P1ij(cx,cy,t);
        p2 :=P2ij(cx,cy,tprev);
        q1 :=Q1ij(cx,cy,t);
        q2 :=Q2ij(cx,cy,tprev);
         r :=Rij(cx,cy,tprev);
         s :=Sij(cx,cy,tprev);
        IF (DIM(Line,1)=j) THEN
          a := (-alpha1*p1 +beta1*q1);
          b := (1. + 2.*alpha1*p1) ;
          c := (-alpha1 * p1 - beta1 *q1);
          d :=  u*(1. - 2.*alpha2*p2 + tau*r)
              + RECEIVE.down[1](u)*(alpha2*p2 + beta2*q2)
              + RECEIVE.up[1](u)  *(alpha2*p2 - beta2*q2)
              + tau*s;
        END;
      END;
    END;
  END;

  IF (DIM(Line,2)=n) THEN
    ri := REAL(n);
    cx := x0+ri*hx;
    FOR j:= 1 TO m DO
      rj := REAL(j);
      cy := y0+rj*hy;
      p1 :=P1ij(cx,cy,t);
      p2 :=P2ij(cx,cy,tprev);
      q1 :=Q1ij(cx,cy,t);
      q2 :=Q2ij(cx,cy,tprev);
       r :=Rij(cx,cy,tprev);
       s :=Sij(cx,cy,tprev);
      bound :=Bound(x0*REAL(n-1)*hx,cy,t);
      IF (DIM(Line,1)=j) THEN
        a := (-alpha1*p1 +beta1*q1);
        b := (1. + 2.*alpha1*p1) ;
        d := bound*(alpha1 * p1 + beta1 *q1)  
            + u*(1. - 2.*alpha2*p2 + tau*r)
            + RECEIVE.down[1](u)*(alpha2*p2 + beta2*q2)
            + RECEIVE.up[1](u)  *(alpha2*p2 - beta2*q2)
            + tau*s;
      END;
    END;
  END;

 END InitKoeff1;

 PROCEDURE InitKoeff2(VAR a,b,c,d: Line OF REAL; 
             u: Line OF REAL;x0,y0,t,tau:REAL;
        VAR P1ij,P2ij,Q1ij,Q2ij,Rij,Sij,Bound:Coeff3);

 VAR alpha1,alpha2,beta1, beta2,ri,rj,cx,cy,tprev,
     p1,p2,q1,q2,r,s,bound : REAL;
     i,j : INTEGER;
 BEGIN
   tprev := t-tau/2.;
  alpha1 := tau/hx/hx;
  alpha2 := tau/hy/hy;
  beta1  := tau/2./hx;
  beta2  := tau/2./hy;

   IF DIM(Line,1)=1 THEN
     cy := y0+hy;
     FOR i:= 1 TO n DO
       ri := REAL(i);
       cx := x0+ri*hx;
       p1 :=P1ij(cx,cy,tprev);
       p2 :=P2ij(cx,cy,t);
       q1 :=Q1ij(cx,cy,tprev);
       q2 :=Q2ij(cx,cy,t);
        r :=Rij(cx,cy,t);
        s :=Sij(cx,cy,t);
       bound :=Bound(cx,y0,t);
       IF DIM(Line,2)=i THEN
         b := (1. + alpha2*p2 -tau*r);
         c := (-alpha2*p2 - beta2*q2);
         d := bound*(alpha2*p2 - beta2*q2)
             + u * (1. -2.*alpha1*p1)
             + RECEIVE.right[1](u)*(alpha1*p1 + beta1*q1)
             + RECEIVE.left[1](u)*(alpha1*p1 - beta1*q1)
             + tau*s; 
       END;
     END;
   END;

   FOR i:= 2 TO m-1 DO
     ri := REAL(i);
     cy := y0+ri*hy;
     IF DIM(Line,1)=i THEN
       FOR j:= 1 TO n DO
         rj := REAL(j);
         cx := x0+rj*hx;
         p1 :=P1ij(cx,cy,tprev);
         p2 :=P2ij(cx,cy,t);
         q1 :=Q1ij(cx,cy,tprev);
         q2 :=Q2ij(cx,cy,t);
          r :=Rij(cx,cy,t);
          s :=Sij(cx,cy,t);
         IF DIM(Line,2)=j THEN
           a :=(-alpha2*p2 + beta2*q2); 
           b := (1. + alpha2*p2 -tau*r);
           c := (-alpha2*p2 - beta2*q2);
           d :=  u * (1. -2.*alpha1*p1)
               + RECEIVE.right[1](u)*(alpha1*p1 + beta1*q1)
               + RECEIVE.left[1](u)*(alpha1*p1 - beta1*q1)
               + tau*s; 
         END;
       END;
     END;
   END;

   IF DIM(Line,1)=m THEN
     ri := REAL(m);
     cy := y0+ri*hy;
     FOR j:= 1 TO n DO
       rj := REAL(j);
       cx := x0+rj*hx;
       p1 :=P1ij(cx,cy,tprev);
       p2 :=P2ij(cx,cy,t);
       q1 :=Q1ij(cx,cy,tprev);
       q2 :=Q2ij(cx,cy,t);
        r :=Rij(cx,cy,t);
        s :=Sij(cx,cy,t);
       bound := Bound(cx,y0+REAL(m-1)*hy,t);
       IF DIM(Line,2)=j THEN
         a :=(-alpha2*p2 + beta2*q2); 
         b := (1. + alpha2*p2 -tau*r);
         d := bound*(alpha2*p2 + beta2*q2)
             +  u * (1. -2.*alpha1*p1)
             + RECEIVE.right[1](u)*(alpha1*p1 + beta1*q1)
             + RECEIVE.left[1](u)*(alpha1*p1 - beta1*q1)
             + tau*s; 
        END;
       END;
     END;

 END InitKoeff2;


BEGIN (*altdir*)
 IF (output=1) THEN
  IF (n*m>maxplotnumber) THEN
   WriteString("pdiff2 overflow error : output set to stdout");
   output := 0;
  END;
  IF (filename[0]=0C) THEN
   output := 0;
  END;
 ELSIF ((output=0) AND (filename[0]<>0C)) THEN 
   OpenOutput(filename);
 END;

 n := n-2;
 m := m-2;

 log2n := ceiling( (ln(REAL(n))/ln(2.)) ) ;
 log2m := ceiling( (ln(REAL(m))/ln(2.)) ) ;
 
 N := n+1; 
 M := m+1; 

 FOR k:=0 TO N DO     (* Initial and boundary condition *)
   FOR l:=0 TO M DO
     IF ((DIM(Line,2)=k) AND (DIM(Line,1)=l)) THEN
      IF ((k=0) OR (k=N) OR (l=0) OR (l=M)) THEN
       Rek[0] := CR_Bound(x0+REAL(k)*hx,y0+REAL(l)*hy,0.);
      ELSE
       Rek[0] := CR_Init(x0+REAL(k)*hx,y0+REAL(l)*hy); 
      END;
     END;
   END;
 END;

 WriteOut(Rek[0],x0,hx,y0,hy,output*1);

 Rek[1] := 0.0;  (* Vorinitialisierung *) 
 Rek[2] := 1.0;
 Rek[3] := 0.0;
 Rek[4] := 0.0;
 

 FOR Time := 0 TO T DO 
   InitKoeff1(Rek[1],Rek[2],Rek[3],Rek[4],Rek[0],x0,y0,REAL(Time)*tau,tau
   , CR_P1ij, CR_P2ij, CR_Q1ij, CR_Q2ij, CR_Rij, CR_Sij, CR_Bound);

   FOR k:= 1 TO log2n DO
     IF ((0<DIM(Line,2)<N) AND (0<DIM(Line,1)<M)) THEN

       Rek[5] := -Rek[1] / RECEIVE.right[k](Rek[2]);     (* alpha *)
       Rek[6] := -Rek[3] / RECEIVE.left[k](Rek[2]);      (* gamma  *)
       Rek[2] := Rek[5] * RECEIVE.right[k](Rek[3]) + Rek[2] 
               + Rek[6] * RECEIVE.left[k](Rek[1]);       (* b *)
       Rek[1] := Rek[5] * RECEIVE.right[k](Rek[1]);      (* a *)
       Rek[3] := Rek[6] * RECEIVE.left[k](Rek[3]);       (* c *)
       Rek[4] := Rek[5] * RECEIVE.right[k](Rek[4]) + Rek[4] 
               + Rek[6] * RECEIVE.left[k](Rek[4]);       (* d *)
  
     END;
   END; 

  IF ((0<DIM(Line,2)<N) AND (0<DIM(Line,1)<M)) THEN
    Rek[0] := Rek[4] / Rek[2]; (* x *)
  END; 

  InitKoeff2(Rek[1],Rek[2],Rek[3],Rek[4],Rek[0],x0,y0,REAL(Time)*tau+tau/2.,tau
  , CR_P1ij, CR_P2ij, CR_Q1ij, CR_Q2ij, CR_Rij, CR_Sij, CR_Bound);

  FOR k:= 1 TO log2m DO
    IF ((0<DIM(Line,2)<N) AND (0<DIM(Line,1)<M)) THEN
      Rek[5] := -Rek[1] / RECEIVE.down[k](Rek[2]);    (* alpha *)
      Rek[6] := -Rek[3] / RECEIVE.up[k](Rek[2]);      (* gamma  *)
      Rek[2] := Rek[5] * RECEIVE.down[k](Rek[3]) + Rek[2] 
              + Rek[6] * RECEIVE.up[k](Rek[1]);       (* b *)
      Rek[1] := Rek[5] * RECEIVE.down[k](Rek[1]);     (* a *)
      Rek[3] := Rek[6] * RECEIVE.up[k](Rek[3]);       (* c *)
      Rek[4] := Rek[5] * RECEIVE.down[k](Rek[4]) + Rek[4] 
              + Rek[6] * RECEIVE.up[k](Rek[4]);       (* d *)
    END;
  END; 
 
  IF ((0<DIM(Line,2)<N) AND (0<DIM(Line,1)<M)) THEN
    Rek[0] := Rek[4] / Rek[2]; (* x *)
  END;  

  (* set boundary condition for output *)
  IF (DIM(Line,2)=0) THEN 
   FOR i:= 0 TO M DO
    IF (DIM(Line,1)=i) THEN
      Rek[0] := CR_Bound(x0,y0+REAL(i)*hy,REAL(Time)*tau+tau/2.);
    END;
   END;
  END;
  IF (DIM(Line,2)=n) THEN 
   FOR i:= 0 TO M DO
    IF (DIM(Line,1)=i) THEN
      Rek[0] := CR_Bound(x0+REAL(n)*hx,y0+REAL(i)*hy,REAL(Time)*tau+tau/2.);
    END;
   END;
  END;
  IF (DIM(Line,1)=0) THEN 
   FOR i:= 0 TO N DO
    IF (DIM(Line,2)=i) THEN
      Rek[0] := CR_Bound(x0+REAL(i)*hx,y0,REAL(Time)*tau+tau/2.);
    END;
   END;
  END;
  IF (DIM(Line,1)=m) THEN 
   FOR i:= 0 TO N DO
    IF (DIM(Line,2)=i) THEN
      Rek[0] := CR_Bound(x0+REAL(i)*hx,y0+REAL(m)*hy,REAL(Time)*tau+tau/2.);
    END;
   END;
  END;

  WriteOut(Rek[0],x0,hx,y0,hy,output*(Time+2));

 END; (*FOR*) 

 IF (output<>0) THEN WriteCommandfile(filename,T+2);
 ELSIF (filename[0]<>0C) THEN CloseOutput;
 END;

END altdir;

BEGIN
END pdiff2.
