IMPLEMENTATION MODULE pdiff3;
(* methods for threedimensional linear pdes *)
(* REDUCE.MAX (eps)                         *)

CONFIGURATION open[*],[*],[*];

CONNECTION 
up     : open[zi,yi,xi] <-> open[zi+1,yi,xi] : down;
south  : open[zi,yi,xi] <-> open[zi,yi+1,xi] : north;
west   : open[zi,yi,xi] <-> open[zi,yi,xi+1] : east;


PROCEDURE ppdg3( X, Y, Z, timesteps               : CARDINAL;
                 x1, hx, y1, hy, z1, hz, tau, eps : REAL;
             VAR P1,P2,P3,Q1,Q2,Q3,R,S,bound      : Coeff4;
             VAR init                             : Coeff3);

CONFIGURATION Para=open[1..Z],[1..Y],[1..X]; 

VAR Space,p1,p2,p3,q1,q2,q3,r,s,K1,K2,K3,K4,K5,K6,K7,K8 : Para OF REAL;
    i, j, k, l                                          : CARDINAL;
    xk,yk,zk,alpha1,alpha2,alpha3,beta1,beta2,beta3     : REAL;

PROCEDURE Result(Source,K1,K2,K3,K4,K5,K6,K7,K8: Para OF REAL):Para OF REAL;
(* Berechnung der Werte nach der expliziten Formel *)
BEGIN
 IF  (1 < DIM(Para,1) < X) AND
    ((1 < DIM(Para,2) < Y) AND
     (1 < DIM(Para,3) < Z)) THEN 
   Source := ( K2*RECEIVE.west(Source) + K6*RECEIVE.up(Source)
               +K4*RECEIVE.south(Source)
               +K1*RECEIVE.east(Source) + K5*RECEIVE.down(Source)
               +K3*RECEIVE.north(Source) + K7*Source +K8 );
 END;
 RETURN Source;
END Result;

PROCEDURE WriteOut(This : Para OF REAL);
BEGIN
  WriteReal(This,8);
END WriteOut;


BEGIN

 alpha1 := tau/hx/hx;
 alpha2 := tau/hy/hy;
 alpha3 := tau/hz/hz;
 beta1  := tau/2./hx;
 beta2  := tau/2./hy;
 beta3  := tau/2./hz;

 FOR i:= 2 TO X-1 DO    (* initial condition *)
   xk := FLOAT(i);
   FOR j:= 2 TO Y-1 DO
     yk:=FLOAT(j);
     FOR k := 2 TO Z-1 DO
       zk := FLOAT(k);
       IF (((DIM(Para,1)=i) AND (DIM(Para,2)=j))AND(DIM(Para,3)=k)) THEN 
           Space := init(x1+(xk-1.)*hx,y1+(yk-1.)*hy, z1+(zk-1.)*hz);
       END;
     END;
   END;
 END;

 WriteOut(Space);
 
 K1 := 0.0;
  l := 0;

 REPEAT
  INC(l);
   FOR i:= 1 TO X DO
    xk := FLOAT(i);
    FOR j:= 1 TO Y DO
     yk:=FLOAT(j);
     FOR k := 1 TO Z DO
        zk := FLOAT(k);
        IF (((DIM(Para,1)=i) AND (DIM(Para,2)=j))AND(DIM(Para,3)=k)) THEN 
          p1:=P1(x1+(xk-1.)*hx, y1+(yk-1.)*hy, z1+(zk-1.)*hz, FLOAT(l-1)*tau);
          p2:=P2(x1+(xk-1.)*hx, y1+(yk-1.)*hy, z1+(zk-1.)*hz, FLOAT(l-1)*tau);
          p3:=P3(x1+(xk-1.)*hx, y1+(yk-1.)*hy, z1+(zk-1.)*hz, FLOAT(l-1)*tau);
          q1:=Q1(x1+(xk-1.)*hx, y1+(yk-1.)*hy, z1+(zk-1.)*hz, FLOAT(l-1)*tau);
          q2:=Q2(x1+(xk-1.)*hx, y1+(yk-1.)*hy, z1+(zk-1.)*hz, FLOAT(l-1)*tau);
          q3:=Q3(x1+(xk-1.)*hx, y1+(yk-1.)*hy, z1+(zk-1.)*hz, FLOAT(l-1)*tau);
          r := R(x1+(xk-1.)*hx, y1+(yk-1.)*hy, z1+(zk-1.)*hz, FLOAT(l-1)*tau);
          s := S(x1+(xk-1.)*hx, y1+(yk-1.)*hy, z1+(zk-1.)*hz, FLOAT(l-1)*tau);
          IF ((i=1) OR (j=1) OR (k=1) OR (i=X) OR (j=Y) OR (k=Z)) THEN 
            (* boundary condition *)
            Space:=bound(x1+(xk-1.)*hx,y1+(yk-1.)*hy, 
                         z1+(zk-1.)*hz,FLOAT(k-1)*tau);
          END;
        END;
     END;
    END;
   END;

   K1 := alpha1*p1 + beta1*q1;
   K2 := alpha1*p1 - beta1*q1;
   K3 := alpha2*p2 + beta2*q2;
   K4 := alpha2*p2 - beta2*q2;
   K5 := alpha3*p3 + beta3*q3;
   K6 := alpha3*p3 - beta3*q3;
   K7 := 1. - 2.*alpha1*p1 -2.*alpha2*p2 -2.*alpha3*p3 + tau*r;
   K8 := tau*s;
 
   p1 := Space; (* missbrauche p1 als Hilfsvariable *)

   Space := Result(Space,K1,K2,K3,K4,K5,K6,K7,K8);
   
   WriteOut(Space);

 UNTIL ((REDUCE.MAX(ABS(Space-p1))< eps ) OR (l = timesteps)) 
END ppdg3;


PROCEDURE epdg3( X, Y, Z, it                        : CARDINAL; 
                 x1, hx, y1, hy, z1, hz, eps        : REAL; 
             VAR PK1,PK2,PK3,QK1,QK2,QK3,RK,SK,init : Coeff3);


CONFIGURATION Space=open[1..Z],[1..Y],[1..X];
               
VAR  ellp,P1,P2,P3,Q1,Q2,Q3,R,S,k1,k2,k3,k4,k5,k6,k8 : Space OF REAL;
     step, i, k, l                                   : INTEGER; 
     alpha1, alpha2, alpha3, beta1, beta2, beta3     : REAL;


 PROCEDURE Result( Res,k1,k2,k3,k4,k5,k6,k7,k8: Space OF REAL):Space OF REAL;
 BEGIN
  IF (1<DIM(Space,1)<X) AND
     (1<DIM(Space,2)<Y) AND (1<DIM(Space,3)<Z) THEN 
     Res := ( ( k2*RECEIVE.west(Res) + k3* RECEIVE.north(Res) + 
             k1*RECEIVE.east(Res) + k4* RECEIVE.south(Res) +
             k6*RECEIVE.up(Res) + k5* RECEIVE.down(Res) + k7)/k8);
  END;
  RETURN  Res;
 END Result;

 PROCEDURE SetInit(VAR This : Space OF REAL; VAR init: Coeff3);
 VAR i,k,l : CARDINAL; 
 BEGIN
   FOR i:=1 TO X DO
    FOR k:=1 TO Y DO
     FOR l:=1 TO Z DO
       IF (DIM(Space,1)=i) AND (DIM(Space,2)=k) AND (DIM(Space,3)=l) THEN
         This := init(x1+REAL(i-1)*hx,y1+REAL(k-1)*hy,z1+REAL(l-1)*hz);
       END;
     END;
    END;
   END;
 END SetInit;

 PROCEDURE WriteOut(This :  Space OF REAL);
 BEGIN
   WriteReal(This,8); 
 END WriteOut;

BEGIN 

 FOR i := 1 TO X DO
  FOR k := 1 TO Y DO
   FOR l := 1 TO Z DO
     IF (DIM(Space,1)=i) AND (DIM(Space,2)=k) AND (DIM(Space,3)=l) THEN
      P1 := PK1(REAL(i-1)*hx+x1,REAL(k-1)*hy+y1,REAL(l-1)*hz+z1);
      P2 := PK2(REAL(i-1)*hx+x1,REAL(k-1)*hy+y1,REAL(l-1)*hz+z1); 
      P3 := PK3(REAL(i-1)*hx+x1,REAL(k-1)*hy+y1,REAL(l-1)*hz+z1); 
      Q1 := QK1(REAL(i-1)*hx+x1,REAL(k-1)*hy+y1,REAL(l-1)*hz+z1);
      Q2 := QK2(REAL(i-1)*hx+x1,REAL(k-1)*hy+y1,REAL(l-1)*hz+z1);
      Q3 := QK3(REAL(i-1)*hx+x1,REAL(k-1)*hy+y1,REAL(l-1)*hz+z1);
      S  :=  SK(REAL(i-1)*hx+x1,REAL(k-1)*hy+y1,REAL(l-1)*hz+z1);
      R  :=  RK(REAL(i-1)*hx+x1,REAL(k-1)*hy+y1,REAL(l-1)*hz+z1);
     END;
   END;
  END;
 END;

 alpha1 := 1./hx/hx;
 alpha2 := 1./hy/hy;
 alpha3 := 1./hz/hz;
 beta1  := 1./2./hx;
 beta2  := 1./2./hy;
 beta3  := 1./2./hz;

 k1:= alpha1*P1 + beta1*Q1; 
 k2:= alpha1*P1 - beta1*Q1;
 k3:= alpha2*P2 + beta2*Q2;
 k4:= alpha2*P2 - beta2*Q2;
 k5:= alpha3*P3 + beta3*Q3;
 k6:= alpha3*P3 - beta3*Q3;
 k8:= 2.*alpha1*P1 + 2.*alpha2*P2 + 2.*alpha3*P3- R;

 SetInit(ellp,init); 
 WriteOut(ellp);

 step := 0;

 REPEAT
   INC(step);
   P1 := ellp;
   ellp := Result(ellp,k1,k2,k3,k4,k5,k6,S,k8);
 UNTIL ((REDUCE.MAX(ABS(ellp-P1))<= eps) OR (step=it))

 WriteOut(ellp);
END epdg3;

BEGIN
END pdiff3.
