IMPLEMENTATION MODULE ga;
(* Genetic Algorithm Simulation, Thomas Braunl Univ. Stuttgart 1995 *)

PROCEDURE Init(VAR g: pop OF ARRAY OF BOOLEAN);
VAR i: INTEGER;
BEGIN
  FOR i:=0 TO HIGH(g) DO
    g[i] := RandomBool(pop);
  END;
END Init;


PROCEDURE Selection(VAR old_pop,sel_pop: pop OF ARRAY OF BOOLEAN;
                    VAR fit: pop OF INTEGER);
VAR take, wheel_of_fit: pop OF INTEGER;
    fit_val, i        : INTEGER;
BEGIN
  fit_val := 0;  (* generate fitness distribtion *)
  FOR i:=0 TO HIGH(old_pop) DO
    INC(fit_val, fitness<:i:>);
    wheel_of_fit<:i:> := fit_val
  END;
  take := RandomInt(pop) MOD fit_val;  (* 0..sum(fit)-1 *)
  FOR i:=0 TO HIGH(old_pop) DO
    IF take<:i:> < wheel_of_fit THEN  (* hit on wheel segment *)
      IF REDUCE.MIN(wheel_of_fit) = wheel_of_fit THEN
        sel_pop<:i:> := REDUCE.FIRST(old_pop)  (* select individuum *)
      END;
    END;
  END;
  IF debug THEN WriteString("after Selection"); WriteLn; Check(sel_pop) END;
END Selection;
               
            
PROCEDURE CrossOver(VAR sel_pop,new_pop: pop OF ARRAY OF BOOLEAN);
VAR sel_neighbor, new_neighbor: pop OF ARRAY[0..MaxGeneSize] OF BOOLEAN;
    point                     : pop OF INTEGER;
    i                         : INTEGER;
BEGIN
  IF EVEN(ID(pop))
    THEN SEND.left(sel_pop, sel_neighbor);
    ELSE (* only odd individuals work *)
    point := RandomInt(pop) MOD gene_size; (* cross-over point *)
    FOR i:=0 TO gene_size-1 DO
      IF i<point THEN new_pop[i]      := sel_pop[i];
                      new_neighbor[i] := sel_neighbor[i]
                 ELSE new_pop[i]      := sel_neighbor[i];
                      new_neighbor[i] := sel_pop[i]
      END;
    END;
    SEND.right(new_neighbor, new_pop);  (* update even individuals *)
  END;
  IF debug THEN WriteString("after Cross"); WriteLn; Check(new_pop) END;
END CrossOver;                             


PROCEDURE Mutation(VAR g: pop OF ARRAY OF BOOLEAN);
VAR i: INTEGER;
BEGIN
  FOR i:=0 TO HIGH(g) DO
    IF RandomInt(pop) MOD mut_fac = 0 THEN
      g[i] := NOT g[i];
    END;
  END;
  IF debug THEN WriteString("after Mut"); WriteLn; Check(g) END;
END Mutation;

END ga.
