MODULE gauss;
(* equation solving using the Gauss-Jordan method *)
(* Braunl, Univ. Stuttgart, Sep. 1994             *)
CONST n    = 4;

CONFIGURATION  grid [1..n],[1..n+1];
CONNECTION     up:  grid[i,j]  <->  grid[(i-1), j] :down;
               row: grid[i,j]   ->  grid[i, 1..n+1]; 
               col: grid[i,j]   ->  grid[1..n, j]; 

VAR a,b     : ARRAY[1..n] OF REAL;
    vmat    : grid OF REAL;
    k       : INTEGER;


PROCEDURE elimination (VAR mat: grid OF REAL);
VAR i,num,diag           : INTEGER;
    diag_el, el          : REAL;
    ok                   : BOOLEAN;
    change1, change2,
    first_el, top_el     : grid OF REAL;
BEGIN 
  FOR diag := 1 TO n DO
    diag_el := mat <:diag,diag:>;
    IF (diag_el = 0.0) AND (diag<n) THEN  (* change lines *)
      i := diag;
      REPEAT
        INC(i);
        el := mat <:i,diag:>;
        ok := el <> 0.0;
      UNTIL (i=n) OR ok;
      IF ok THEN
        num := i-diag;
        SEND.down:num (mat, change1);
        SEND.up:num   (mat, change2);   
        IF DIM(grid,2) = i    THEN mat := change1 END;   
        IF DIM(grid,2) = diag THEN mat := change2 END; 
      END;
    END; (* diag_el = 0.0 *)

    IF DIM(grid,1) = diag THEN
      SEND.row(mat,first_el)
    END;
    IF first_el <> 0.0 THEN mat := mat / first_el END;
     IF DIM(grid,2) = diag THEN
      SEND.col(mat,top_el)
    END;
    IF (DIM(grid,2) <> diag) AND (first_el <> 0.0) THEN
      mat := mat - top_el
    END;
  END; (* for diag *)
  (* divide b by diagonal *)
END elimination;


BEGIN  (* main program *)
  WriteString("Enter Matrix /"); WriteInt(n,1); WriteLn;
  ReadReal(vmat);
  elimination(vmat);
  IF DIM(grid,1) = DIM(grid,2) THEN STORE(vmat,a) END;
  IF DIM(grid,1) = n+1         THEN STORE(vmat,b) END;
  WriteString("Results:"); WriteLn;
  FOR k:=1 TO n DO
    WriteFixPt(b[k]/a[k], 10,2); WriteLn;
  END;
END gauss.

