MODULE rowcol;
(* Row-Column Sorting using OETS as base algorithm, Braunl 1995 *)
CONST n = 10;
CONFIGURATION grid[1..n],[1..n];
CONNECTION left: grid[i,j] <-> grid[i,j-1] :right;
           up  : grid[i,j] <-> grid[i-1,j] :down;

VAR step,num,logn,iter: INTEGER;
    a                 : ARRAY[1..n] OF INTEGER;
    val,comp          : grid OF INTEGER;
    lhs               : grid OF BOOLEAN;

PROCEDURE xor(a,b: grid OF BOOLEAN): grid OF BOOLEAN;
BEGIN
  RETURN a#b
END xor;


BEGIN
  WriteString('Enter '); WriteInt(n*n,1); WriteString(' values: '); WriteLn;
  ReadInt(val);
  logn:=1; num:=2;
  WHILE num<n DO  (* determine ceiling(log2(n)) *)
    INC(logn);
    num:=2*num
  END;

  FOR iter:=1 TO logn DO
    (* sort rows alternating *)
    lhs := ODD(DIM(grid,1));  (* PE is left-hand-side of a comparison *)
    FOR step:=1 TO n DO
      IF lhs THEN comp := RECEIVE.left (val)
             ELSE comp := RECEIVE.right(val)
      END;
      IF xor(lhs, EVEN(DIM(grid,2))) = (comp<val) THEN val:=comp END;
      lhs := NOT lhs;
    END;

    (* sort columns *)
    lhs := ODD(DIM(grid,2));  (* PE is left-hand-side of a comparison *)
    FOR step:=1 TO n DO                                              
      IF lhs THEN comp := RECEIVE.up(val)                     
             ELSE comp := RECEIVE.down(val)                     
      END;                                                       
      IF lhs = (comp<val) THEN val:=comp END; 
      lhs := NOT lhs;                                                          
    END;                                                       
  END; (* for iter *)

  (* sort all rows in ascending order *)
  lhs := ODD(DIM(grid,1));  (* PE is left-hand-side of a comparison *)
  FOR step:=1 TO n DO
    IF lhs THEN comp := RECEIVE.left (val)
           ELSE comp := RECEIVE.right(val)
    END;
    IF lhs = (comp<val) THEN val:=comp END;
    lhs := NOT lhs;
  END;

  WriteString("Sorted Numbers:"); WriteLn;
  WriteInt(val,5);
END rowcol.

