MODULE seidel;
(* modified gauss-seidel iterative method *)
(* see: Akl or Leighton                   *)
CONST n        =    4;
      eps      =    0.001;
      max_iter = 1000;
      init_val =    1.0;

CONFIGURATION grid[0..n-1],[0..n];
CONNECTION diag   : grid[i,j] -> {i#j<n} grid[i,i];
           spread : grid[i,j] ->   {j<n} grid[0..n-1,j];
           bspread: grid[i,n] ->         grid[i,i];

VAR iter, k        : INTEGER;
    regular,aborted: BOOLEAN;
    diff           : REAL;
    a,b, x,old,nsum: grid OF REAL;

BEGIN
  WriteString("Enter Matrix /"); WriteInt(n,1); WriteLn;
  ReadReal(a);
  aborted := FALSE;
  IF DIM(grid,1) = DIM(grid,2) THEN
    IF a = 0.0 THEN 
      WriteString("aborted: a[i,i] = 0.0"); WriteLn;
      aborted := TRUE;
    END
  END;

  IF NOT aborted THEN 
    regular := FALSE;
    x   := init_val;
    old := init_val;
    SEND.bspread(a,b);
    iter := 0;
    REPEAT
      SEND.diag:#SUM(a*x, nsum);
      IF DIM(grid,1) = DIM(grid,2) THEN (* diagonal *)
        x := 0.9 * x + 0.1 * (b - nsum) / a;
        (* x := (b - nsum) / a; *)
        diff := REDUCE.SUM( ABS(x-old) );
        IF diff < eps THEN
          regular := TRUE;
        ELSE
          old := x;
          SEND.spread(x,x);
          INC(iter);
        END; (* if *)
      END;
    UNTIL regular OR (iter = max_iter);
    WriteInt(iter,3); WriteString(" iterations"); WriteLn;
    WriteString("Results:"); WriteLn;
    FOR k:=1 TO n DO
      WriteFixPt(x<<k>>, 10,2); WriteLn;
    END;
  END; (* if *)
END seidel.

