MODULE xrowcol;
(* Row-Column Sorting using OETS as base algorithm, Braunl 1995 *)
(* with X-Window Visualization added                            *)
FROM Graphics IMPORT OpenWindow, CloseWindow, SetAreaXYZ, window;
FROM ImageIO  IMPORT color, gray;
FROM Trans    IMPORT gray2rainbow;

CONST n    = 25;
      zoom =  8;
CONFIGURATION grid[1..n],[1..n];
CONNECTION left: grid[i,j] <-> grid[i,j-1] :right;
           up  : grid[i,j] <-> grid[i-1,j] :down;

VAR step,num,logn,iter: INTEGER;
    a                 : ARRAY[1..n] OF INTEGER;
    entry,comp        : grid OF RECORD
                                  val: INTEGER;
                                  col: color;
                                END;

    lhs               : grid OF BOOLEAN;
    ch                : CHAR;
    win               : window;

PROCEDURE xor(a,b: grid OF BOOLEAN): grid OF BOOLEAN;
BEGIN
  RETURN a#b
END xor;


BEGIN
  win := OpenWindow("xrowcol", zoom*n, zoom*n);
  entry.val := RandomInt(grid) MOD 256;  (* random init [0..255] *)
  entry.col := gray2rainbow(entry.val);
  SetAreaXYZ(entry.col, 0,0,zoom);

  logn:=1; num:=2;
  WHILE num<n DO  (* determine ceiling(log2(n)) *)
    INC(logn);
    num:=2*num
  END;

  FOR iter:=1 TO logn DO
    (* sort rows alternating *)
    lhs := ODD(DIM(grid,1));  (* PE is left-hand-side of a comparison *)
    FOR step:=1 TO n DO
      IF lhs THEN comp := RECEIVE.left (entry)
             ELSE comp := RECEIVE.right(entry)
      END;
      IF xor(lhs, EVEN(DIM(grid,2))) = (comp.val<entry.val) THEN entry:=comp END;
      lhs := NOT lhs;
    END;
    SetAreaXYZ(entry.col, 0,0,zoom);

    (* sort columns *)
    lhs := ODD(DIM(grid,2));  (* PE is left-hand-side of a comparison *)
    FOR step:=1 TO n DO                                              
      IF lhs THEN comp := RECEIVE.up  (entry)                     
             ELSE comp := RECEIVE.down(entry)                     
      END;                                                       
      IF lhs = (comp.val<entry.val) THEN entry:=comp END; 
      lhs := NOT lhs;                                                          
    END;                                                       
    SetAreaXYZ(entry.col, 0,0,zoom);
  END; (* for iter *)

  (* sort all rows in ascending order *)
  lhs := ODD(DIM(grid,1));  (* PE is left-hand-side of a comparison *)
  FOR step:=1 TO n DO
    IF lhs THEN comp := RECEIVE.left (entry)
           ELSE comp := RECEIVE.right(entry)
    END;
    IF lhs = (comp.val<entry.val) THEN entry:=comp END;
    lhs := NOT lhs;
  END;

  SetAreaXYZ(entry.col, 0,0,zoom);
  WriteString("Press RETURN for termination"); WriteLn;
  Read(ch);
  CloseWindow(win);
END xrowcol.

