MODULE autobahn;
(* traffic jam simulation              *)
(* Thomas Braunl, Univ. Stuttgart 1994 *)

CONST cars      =  10;    (* number of cars on autobahn          *)
      steps     =  20;    (* number of simulation steps          *)
      max_speed =   0.1;  (* maximum speed of overall distance   *)
      max_accel =   0.05; (* maximum accelaration in a time step *)
      min_dist  =   0.05; (* car slows down below this distance  *)
      f_acc     =   0.3;  (* speed / dist factor                 *)

CONFIGURATION ring[0..cars-1];
CONNECTION next: ring[i] <-> ring[(i+1) MOD cars]: back;

VAR pos, dist, speed, accel: ring OF REAL; (* car position is [0..1] *)
    max_pos                : REAL;
    collision              : ring OF BOOLEAN; 
    time                   : INTEGER;

BEGIN
  pos   := FLOAT(ID(ring)) / FLOAT(cars);  (* init with equal distance [0..1] *)
  speed := 0.0;
  FOR time := 1 TO steps DO
    WriteInt(time,3); WriteString(". step ");  WriteFixPt(pos,4,3);
    WriteString("          ");  WriteBool(collision,5);
    dist := MOVE.back(pos) - pos;
    max_pos := REDUCE.MAX(pos);
    IF pos = max_pos THEN dist := 1.0 - dist END;  (* end of ring *)
    collision := dist < 0.0;
    IF collision THEN speed := 0.0;  (* pos unchanged *)
     ELSE (* no collision *)
      (* accel proportional to distance-diff. plus small random term *)
      accel := f_acc * (dist - min_dist) + (RandomReal(ring)-0.5)/100.0;
      IF accel < -max_accel THEN accel := -max_accel
       ELSIF accel > max_accel THEN accel := max_accel
      END;
      speed := speed + accel;
      IF speed < 0.0 THEN speed := 0.0  (* do not back up on autobahn ! *)
       ELSIF speed > max_speed THEN speed := max_speed  (* phys. speed limit *)
      END;
      pos := pos + speed;
      IF pos > 1.0 THEN pos := pos - 1.0 END;      (* end of ring *)
    END;
  END;
END autobahn.

