MODULE heat;
(* simulation of heat dissipation            *)
(* Thomas Braunl, Univ. Stuttgart, Sep. 1994 *)
FROM ImageIO  IMPORT gray;
FROM Graphics IMPORT OpenWindow,CloseWindow,SetgAreaXYZ;

CONST size  =  50;
      spotx = size DIV 3;
      spoty = size DIV 2;
      iter  =  40;
      zoom  =   4;
CONFIGURATION grid[0..size+1],[0..size+1];
CONNECTION left: grid[i,j] <-> grid[i,j-1]: right;
           up:   grid[i,j] <-> grid[i+1,j]: down;

VAR elem : grid OF gray;
    win,i: INTEGER;

BEGIN
  elem :=  70;         (* room temperature *)

  win := OpenWindow("heat",(size+2)*zoom,(size+2)*zoom);
  FOR i:=0 TO iter DO 
    elem := (MOVE.left(elem) + MOVE.right(elem) + 
             MOVE.up  (elem) + MOVE.down (elem)) DIV 4;
    elem<:spotx,spoty:> := 255;  (* hot spot *)
    IF ((DIM(grid,1)=0) OR (DIM(grid,1)=size+1) OR (DIM(grid,2)=size+1)) AND
       (elem > 100) THEN elem := 100      (* steam cooling *)
    END;
    IF DIM(grid,2)=0 THEN elem := 0 END;  (* ice cooling   *)
 
    WriteString("step "); WriteInt(i,3); WriteLn;
    SetgAreaXYZ(elem,0,0,zoom);
  END; (* for *)
  CloseWindow(win);
END heat.

