MODULE xvote;
(* Braunl, Univ. Stuttgart, Sep. 1994 *)
FROM ImageIO  IMPORT color, c_red, c_green;
FROM Graphics IMPORT OpenWindow, CloseWindow, SetAreaXYZ;

CONST height  =  64;
      width   =  64;
      steps   =  20;
      zoom    =   4;

TYPE string   = ARRAY[1..10] OF CHAR;

CONFIGURATION image [0..height-1],[0..width-1];
CONNECTION left: image[i,j] <-> image[i, (j-1) MOD width ] :right;
           up  : image[i,j] <-> image[(i-1) MOD height, j] :down;

VAR step, win: CARDINAL;
    opinion  : image OF BOOLEAN;
    col_im   : image OF color;
       
PROCEDURE a_neighbor(a: image OF BOOLEAN): image OF BOOLEAN;
VAR n: image OF ARRAY[0..7] OF BOOLEAN;
BEGIN
  SEND.up   (a,n[0]);    SEND.down (a,n[1]);
  SEND.left (a,n[2]);    SEND.right(a,n[3]);
  SEND.right(n[0],n[4]); SEND.left (n[0],n[5]);
  SEND.right(n[1],n[6]); SEND.left (n[1],n[7]);
  RETURN n[RandomInt(image) MOD 8];
END a_neighbor;

BEGIN
  win := OpenWindow("vote",zoom*width,zoom*height);
  opinion := RandomBool(image);  (* init *)
  FOR step:=1 TO steps DO
    IF opinion THEN col_im := c_red
               ELSE col_im := c_green
    END;
    SetAreaXYZ(col_im, 0,0,zoom);
    opinion := a_neighbor(opinion);
  END;
  CloseWindow(win);
END xvote.

