MODULE autostereo_bw;
(* FILE:      Random Dot Stereogram in a black/white striped image *)
(* CREATED:   Thomas Braeunl, Universitaet Stuttgart, 1994         *)
FROM ImageIO IMPORT read_b_image, read_c_image, write_c_image, write_b_image,
                    binary, b_white;

CONST 
 strip       =  102;
 num_strips  =    6;
 max_width   =  strip * num_strips;
 max_height  =  300;     (* maximum image height *)

CONFIGURATION image [0..max_height-1],[0..max_width-1];

CONNECTION left: image[i,j] <-> image[i  ,j-1] :right;
           up  : image[i,j] <-> image[i-1,j  ] :down;
           next: image[i,j]  -> image[i   ,j+strip];

VAR width, height,
    dist_right, dist_down: INTEGER;
    st, pattern          : image OF binary;

PROCEDURE generate(VAR pic, pat: image OF binary);
CONST  shift = 1;
VAR s,w,h: INTEGER;
BEGIN
  pic:= b_white;
  read_b_image(pic,"back.ppm",w,h);
  (* IF DIM(image,1) < strip THEN
     IF pic=c_white THEN pic.red   := RandomInt(image) MOD 256;
                        pic.green := pic.red; pic.blue  := 255;
     END;
     END; *)
  s :=1;
  REPEAT
    INC(s);
    WriteString('strip '); WriteInt(s,2); WriteLn;
    IF (s-1)*strip - shift <= DIM(image,1) < s*strip THEN
      pic := RECEIVE.next(pic);
      IF pat THEN SEND.left(pic,pic) END;
    END;
  UNTIL s = num_strips;
END generate;

BEGIN 
  WriteString("Auto-Stereo-Generation Black/White, Braunl 1994"); WriteLn;
  WriteString("Pattern: in.pbm, Back: back.ppm, Output: st.pbm"); WriteLn;
  read_b_image(pattern,"in.pbm", width,height);
  (* center pattern *)
  dist_right := strip + (max_width - strip - width) DIV 2;
  dist_down  := (max_height - height) DIV 2;
  SEND.right:dist_right(pattern,pattern);
  SEND.down :dist_down (pattern,pattern);
  generate(st,pattern);
  write_b_image(st,"st.pbm",max_width,max_height);
END autostereo_bw.

