MODULE autostereo;
(* FILE:      Random Dot Stereogram in a SINGLE striped image *)
(* CREATED:   Thomas Braeunl, Universitaet Stuttgart, 1994    *)
FROM ImageIO IMPORT read_b_image, write_b_image, binary;

CONST 
 strip       =   40;
 border      =   20;
 num_strips  =   10;
 max_width   =  strip * num_strips;
 max_height  =  300;     (* maximum image height *)
 max_steps   =    5;     (* max image elevation  *)

CONFIGURATION image [0..max_height-1],[0..max_width-1];
CONNECTION left: image[i,j] <-> image[i ,j-1] :right;
             up: image[i,j] <-> image[i-1, j] :down;
           next: image[i,j]  -> image[i ,j+strip];

VAR width, height,
    dist_right, dist_down: INTEGER;
    rd,pattern           : image OF binary;

PROCEDURE generate(VAR pic,pat: image OF binary);
CONST  shifts = 1;  (* max. shift depth *)
VAR s: INTEGER;
BEGIN
  IF DIM(image,1) < strip THEN pic := RandomBool(image); END;
  FOR s:=1 TO num_strips DO
    WriteString('strip '); WriteInt(s,2); WriteLn;
    IF (s-1)*strip - shifts <= DIM(image,1) < s*strip THEN
      pic := RECEIVE.next(pic);
      IF pat THEN SEND.left(pic,pic) END;
    END;
  END;
END generate;

BEGIN 
  WriteString("Auto-Stereo-Generation input: in.pbm output: rd.pbm"); WriteLn;
  WriteString("Thomas Braunl, Univ. Stuttgart 1994"); WriteLn;
  read_b_image(pattern,"in.pbm", width,height);
  (* center pattern *)
  dist_right := border + (max_width - border - width)  DIV 2;
  dist_down  := (max_height-height) DIV 2;
  IF (dist_right < border) OR (dist_down < 0) THEN
    WriteString("error: pattern too large for canvas"); WriteLn;
    HALT;
  END;
  SEND.right:dist_right(pattern,pattern);
  SEND.down :dist_down (pattern,pattern);
  generate(rd,pattern);
  write_b_image(rd, "rd.pbm",max_width,max_height);
END autostereo.

