MODULE random_dot;
FROM ImageIO IMPORT gray,binary,color, g_black,g_white,
                    write_c_image;
FROM Local   IMPORT grid, left, right, up, down,
                    sum_3x3, median_5x5;
FROM Trans   IMPORT rgb2color, binary2gray, int2gray, hsv2color;

CONST 
 max_width   =   50;     (* maximum image width  *)
 max_height  =   50;     (* maximum image height *)
 max_steps   =    5;     (* max image elevation  *)

CONFIGURATION image = grid [1..max_height],[1..max_width];

VAR red_green, c_elev    : image OF color;  (* color images      *)
    elevation            : image OF gray;   (* gray scale images *)
    rd_left,rd_right     : image OF binary; (* binary images     *)


PROCEDURE generate_random_dot(VAR l_pic,r_pic: image OF BOOLEAN);
VAR i,num, from_x, from_y, to_x, to_y, shifts: INTEGER;
BEGIN
  l_pic:= RandomBool(grid);
  r_pic := l_pic;
  WriteString("Number of Areas to Elevate: "); ReadInt(num);
  FOR i := 1 TO num DO
    WriteString("Area: from-x from-y to-x to-y shifts ");
    ReadInt(from_x); ReadInt(from_y);
    ReadInt(to_x); ReadInt(to_y);
    ReadInt(shifts);
    IF (from_y <= DIM(image,2) <= to_y) AND 
       (from_x - shifts <= DIM(image,1) <= to_x) THEN
      SEND.left:shifts(r_pic,r_pic)  (* move rectangle *)
    END;
    IF (from_y <= DIM(image,2) <= to_y) AND 
       (to_x - shifts <= DIM(image,1) <= to_x) THEN
      r_pic := RandomBool(grid);               (* fill gap *)
    END;
  END;
END generate_random_dot;


PROCEDURE analyze_random_dot(l_pic,r_pic: image OF BOOLEAN; 
                             steps: CARDINAL; VAR elev: image OF INTEGER);
VAR equal          : image OF BOOLEAN;
    level, maxlevel: image OF INTEGER;
    i              : INTEGER;
BEGIN
  elev     := 0;
  maxlevel := 0;
  FOR i := 0 TO steps DO (* add congruences in 3x3 neighborhood *)
    equal := l_pic = r_pic;
    level := sum_3x3( ORD(equal) );
     
    (* find image plane with max. value *)
    IF equal AND (level > maxlevel) THEN
      elev     := i;
      maxlevel := level;
    END;
    l_pic := MOVE.left(l_pic);  (* move image *)
  END;
END analyze_random_dot;


BEGIN 
  generate_random_dot(rd_left,rd_right);
  (* red := left  green := right  blue := left AND right *)
  red_green := rgb2color(binary2gray(rd_left,  g_white,g_black),
                         binary2gray(rd_right, g_white,g_black),
                         binary2gray(rd_left AND rd_right, g_white, g_black));
  write_c_image(red_green, "rd.ppm",max_width,max_height);

  analyze_random_dot(rd_left,rd_right, max_steps, elevation);

  (* new color table *)
  elevation := int2gray(elevation); 
  c_elev    := hsv2color(elevation, image(255),image(255));
  write_c_image(c_elev, "elev.ppm",max_width,max_height);
  (* extend to whole color range and apply median filter *)
  elevation := median_5x5(elevation); 
  c_elev    := hsv2color(elevation, image(255),image(255));
  write_c_image(c_elev, "filter.ppm",max_width,max_height);
END random_dot.

