IMPLEMENTATION MODULE Strings;

PROCEDURE string2int(s: string): INTEGER;
(* convert a string of digits into an integer *)
VAR i, val: INTEGER;
BEGIN
  val := 0;
  i   := 1;
  WHILE (i < max_string_len) AND ('0' < s[i] < '9') DO
    val := 10*val + ORD(s[i]) - ORD('0');
    INC(i);
  END;
  RETURN val;
END string2int;

PROCEDURE int2string(i, length: INTEGER): string;
(* convert an integer into a string with specified length, with leading zeros *)
VAR s  : string;
    pos: INTEGER;
BEGIN
  IF length >= max_string_len THEN
    WriteString("Error: string to long"); WriteLn;
    s[1] := CHR(0);  (* return empty string *)
   ELSE
    s[length+1] := CHR(0);  (* terminate string *)
    FOR pos := length TO 1 BY -1 DO
      s[pos] := CHR((i MOD 10) + ORD('0'));
      i := i DIV 10;
    END;
  END; (* if *)
  RETURN s;
END int2string;

END Strings.

