IMPLEMENTATION MODULE ComplexArithmetic;
(* Stefan Feyrer, Univ. Stuttgart 1995 *)

(* ------------------------------------------------------------------------ *)

PROCEDURE complex_abs (c: VECTOR OF complex): VECTOR OF REAL;

  BEGIN (* complex_abs *)
    RETURN sqrt (c.re*c.re + c.im*c.im);
  END complex_abs;

(* ------------------------------------------------------------------------ *)

PROCEDURE complex_add (a, b: VECTOR OF complex): VECTOR OF complex;

  VAR result: VECTOR OF complex;

  BEGIN (* complex_add *)
    result.re := a.re + b.re;
    result.im := a.im + b.im;
    RETURN result;
  END complex_add;

(* ------------------------------------------------------------------------ *)

PROCEDURE complex_sub (a, b: VECTOR OF complex): VECTOR OF complex;

  VAR result: VECTOR OF complex;

  BEGIN (* complex_sub *)
    result.re := a.re - b.re;
    result.im := a.im - b.im;
    RETURN result;
  END complex_sub;

(* ------------------------------------------------------------------------ *)

PROCEDURE complex_mult (a, b: VECTOR OF complex): VECTOR OF complex;

  VAR result: VECTOR OF complex;

  BEGIN (* complex_mult *)
    result.re := a.re * b.re - a.im * b.im;
    result.im := a.im * b.re + a.re * b.im;
    RETURN result;
  END complex_mult;

(* ------------------------------------------------------------------------ *)

END ComplexArithmetic.