IMPLEMENTATION MODULE Misc;
(* Michael Lampe, Univ. Stuttgart, March 1995 *)

FROM Local IMPORT grid, left, right, up, down;

(********************************************************************************
     'sum_i' computes local sum of INTEGERS
********************************************************************************)
PROCEDURE sum_i(x: grid OF INTEGER; size: grid OF CARDINAL): grid OF INTEGER;
  VAR i,l: grid OF CARDINAL;
      s,t1,t2: grid OF INTEGER;
BEGIN
  l:=(size-1) DIV 2;
  s:=x; t1:=x; t2:=x;
  FOR i:=1 TO l DO       (* sum in lines *)
    t1:=MOVE.left(t1);
    t2:=MOVE.right(t2);
    s:=s+t1+t2;
  END;
  t1:=s; t2:=s;
  FOR i:=1 TO l DO       (* sum in columns *)
    t1:=MOVE.up(t1);
    t2:=MOVE.down(t2);
    s:=s+t1+t2;
  END;
  RETURN s;
END sum_i;

(********************************************************************************
     'sum_r' computes local sum of REALS
********************************************************************************)
PROCEDURE sum_r(x: grid OF REAL; size: grid OF CARDINAL): grid OF REAL;
  VAR i,l: grid OF CARDINAL;
      s,t1,t2: grid OF REAL;
BEGIN
  l:=(size-1) DIV 2;
  s:=x; t1:=x; t2:=x;
  FOR i:=1 TO l DO
    t1:=MOVE.left(t1);
    t2:=MOVE.right(t2);
    s:=s+t1+t2;
  END;
  t1:=s; t2:=s;
  FOR i:=1 TO l DO
    t1:=MOVE.up(t1);
    t2:=MOVE.down(t2);
    s:=s+t1+t2;
  END;
  RETURN s;
END sum_r;

(********************************************************************************
     'sgn' computes the sign of a real valued vector
********************************************************************************)
PROCEDURE sgn(x: VECTOR OF REAL): VECTOR OF INTEGER;
  VAR s: VECTOR OF INTEGER;
BEGIN
  IF x>0.0 THEN
    s:=1;
  ELSIF x<0.0 THEN
    s:=-1;
  ELSE
    s:=0;
  END;
  RETURN s;
END sgn;


END Misc.