IMPLEMENTATION MODULE Morph;
(* morphological image operations            *)
(* Thomas Braunl, Univ. Stuttgart, July 1995 *)
FROM ImageIO IMPORT binary, b_white, b_black;
FROM Local   IMPORT grid, left, right, up, down; 


(* basic operations *)

PROCEDURE erosion(img: grid OF binary): grid OF binary;
VAR res: grid OF binary;
BEGIN
  res := img AND MOVE.left(img) AND MOVE.right(img);
  res := res AND MOVE.up(res) AND MOVE.down(res);
  RETURN res
END erosion;


PROCEDURE dilation(img: grid OF binary): grid OF binary;
VAR res: grid OF binary;
BEGIN
  res := img OR MOVE.left(img) OR MOVE.right(img);
  res := res OR MOVE.up(res) OR MOVE.down(res);
  RETURN res
END dilation;


PROCEDURE open(img: grid OF binary): grid OF binary;
BEGIN
  RETURN dilation( erosion(img) )
END open;


PROCEDURE close(img: grid OF binary): grid OF binary;
BEGIN
  RETURN erosion( dilation(img) )
END close;


(* further operations *)

PROCEDURE boundary(img: grid OF binary): grid OF binary;
BEGIN
  RETURN img AND NOT erosion(img)
END boundary;


PROCEDURE fill(img: grid OF binary; start_x,start_y: INTEGER): grid OF binary;
VAR grow, new_grow, not_img: grid OF binary;
BEGIN
  (* init grow, only start is TRUE *)
  new_grow := (DIM(grid,1) = start_x) AND (DIM(grid,2) = start_y);
  not_img := NOT img;  (* compute only once *)
  REPEAT
    grow := new_grow;
    new_grow := dilation(grow) AND not_img;
  UNTIL REDUCE.AND(grow = new_grow);
  RETURN grow
END fill;


PROCEDURE connected(img: grid OF binary; start_x,start_y: INTEGER): 
          grid OF binary;
VAR grow, new_grow, not_img: grid OF binary;
BEGIN
  (* init grow, only start is TRUE *)
  new_grow := (DIM(grid,1) = start_x) AND (DIM(grid,2) = start_y);
  REPEAT
    grow := new_grow;
    new_grow := dilation(grow) AND img;
  UNTIL REDUCE.AND(grow = new_grow);
  RETURN grow
END connected;


PROCEDURE skeleton(img: grid OF binary): grid OF binary;
(* skeletization after Jain *)
VAR skel, k_times: grid OF binary;
    ready: BOOLEAN;
BEGIN
  skel := b_white;
  k_times := img;
  WHILE REDUCE.OR(k_times) DO  (* something left *)
    skel := skel OR (k_times AND NOT open(k_times));
    k_times := erosion(k_times);
  END;
  RETURN skel
END skeleton;

END Morph.

