IMPLEMENTATION MODULE Segm;
(* Thomas Braunl, Univ. Stuttgart, 1995 *)
FROM ImageIO IMPORT gray;
FROM Local   IMPORT grid, up,down,left,right;

PROCEDURE region_growing(img: grid OF gray; 
                         seed: INTEGER; threshold: gray): grid OF INTEGER;
(* return label for each pixel, seed (recom. val 8) min region size  *)
(* threshold (recomm. val 20) for max gray value diff. in region     *)
VAR reg, n_reg, old_reg: grid OF INTEGER;
    val, n_val, comp   : grid OF gray;

BEGIN
  IF (DIM(grid,1) MOD seed = 0) AND (DIM(grid,2) MOD seed = 0)
    THEN reg := ID(grid) DIV (seed*seed)  (* unique number for each region *)
    ELSE reg := 0
  END;
  val := img;  (* region gray value *)

  REPEAT
   old_reg := reg;
   n_reg   := reg;

    comp := MOVE.up(img);
    IF ABS(INTEGER(val-comp)) <= threshold THEN  (* type cast for neg. result *)
      SEND.down(reg,n_reg);
      SEND.down(val,n_val);
    END;
    IF n_reg > reg THEN
      reg := n_reg;
      val := n_val
    END;

    comp := MOVE.down(img);
    IF ABS(INTEGER(val-comp)) <= threshold THEN
      SEND.up(reg,n_reg);
      SEND.up(val,n_val);
    END;
    IF n_reg > reg THEN
      reg := n_reg;
      val := n_val
    END;

    comp := MOVE.left(img);
    IF ABS(INTEGER(val-comp)) <= threshold THEN
      SEND.right(reg,n_reg);
      SEND.right(val,n_val);
    END;
    IF n_reg > reg THEN
      reg := n_reg;
      val := n_val
    END;

    comp := MOVE.right(img);
    IF ABS(INTEGER(val-comp)) <= threshold THEN
      SEND.left(reg,n_reg);
      SEND.left(val,n_val);
    END;
    IF n_reg > reg THEN
      reg := n_reg;
      val := n_val
    END;

  UNTIL REDUCE.AND (reg = old_reg);

  RETURN reg
END region_growing;

END Segm.
