MODULE check_io;
FROM ImageIO  IMPORT read_c_image,  read_g_image,  read_b_image,
                     write_c_image, write_g_image, write_b_image,
                     color, gray, binary;

CONFIGURATION grid[0..127],[0..127];
CONNECTION up  : grid[i,j] <-> grid[i+1,j] :down;
           left: grid[i,j] <-> grid[i,j-1] :right;

VAR c           : grid OF color;
    g           : grid OF gray;
    b           : grid OF binary;
    width,height: CARDINAL;

BEGIN
  read_c_image(c,"test.ppm",width,height);
  write_c_image(c,"x.ppm",width,height);

  read_g_image(g,"test.pgm",width,height);
  write_g_image(g, "x.pgm",width,height);

  read_b_image(b,"test.pbm",width,height);
  write_b_image(b, "x.pbm",width,height);
END check_io.

