MODULE check_local;
FROM ImageIO IMPORT color, gray, binary;
IMPORT Local;
CONST size = 3;
CONFIGURATION image = Local.grid[1..size],[1..size];

VAR c1,c2,c3: image OF color;
    g1,g2,g3: image OF gray;
    b1,b2,b3: image OF binary;
    i1,i2,i3: image OF INTEGER;

BEGIN
  g1 := ID(image);
  WriteString("init"); WriteLn;
  WriteInt(g1,3);

  g2 := MOVE.Local.up(g1);
  WriteString("MOVE up"); WriteLn;
  WriteInt(g2,3);

  g2 := MOVE.Local.down(g1);
  WriteString("MOVE down"); WriteLn;
  WriteInt(g2,3);

  g2 := MOVE.Local.left(g1);
  WriteString("MOVE left"); WriteLn;
  WriteInt(g2,3);

  g2 := MOVE.Local.right(g1);
  WriteString("MOVE right"); WriteLn;
  WriteInt(g2,3);


  g2 := Local.sum_3x3(g1);
  WriteString("sum3x3"); WriteLn;
  WriteInt(g2,3);

  i2 := Local.laplace_3x3(g1);
  WriteString("laplace3x3"); WriteLn;
  WriteInt(i2,3);

  i2 := Local.sobel_x_3x3(g1);
  WriteString("sobel x 3x3"); WriteLn;
  WriteInt(i2,3);

  i2 := Local.sobel_y_3x3(g1);
  WriteString("sobel y 3x3"); WriteLn;
  WriteInt(i2,3);

  Local.edges_sobel_3x3(g1,g2,g3);
  WriteString("edges sobel3x3 strength,direction"); WriteLn;
  WriteInt(g2,3);
  WriteInt(g3,3);

  g2 := Local.min_3x3(g1);
  WriteString("min 3x3"); WriteLn;
  WriteInt(g2,3);

  g2 := Local.max_3x3(g1);
  WriteString("max 3x3"); WriteLn;
  WriteInt(g2,3);

  g2 := Local.mean_3x3(g1);
  WriteString("mean 3x3"); WriteLn;
  WriteInt(g2,3);

  g2 := Local.median_3x3(g1);
  WriteString("median 3x3"); WriteLn;
  WriteInt(g2,3);

  g2 := Local.median_3x3fast(g1);
  WriteString("median 3x3fast"); WriteLn;
  WriteInt(g2,3);
END check_local.

