(* main program for test of thinning algorithms                *)
(* W. Rapf 11.94                                               *)
(* compile: p3 ThinningTest Thinning -lImageIO -lTrans -lLocal *)


MODULE check_thin;
FROM ImageIO IMPORT binary, color,
                    b_black, b_white, c_black, c_white, 
                    read_c_image, write_c_image,
                    read_b_image, write_b_image;
FROM Trans IMPORT color2gray, gray2binary;
FROM Local IMPORT grid;
FROM Thinning IMPORT thin_StefRosen, thin_LueWang, thin_HallGuo;

CONST size = 64;
TYPE string = ARRAY[1..100] OF CHAR;
CONFIGURATION image = grid[1..size],[1..size];

VAR bin_image, thin_image: image OF binary;
    col_image: image OF color;
    inputFilename: string;
    width, height: CARDINAL;

BEGIN
  
  WriteString("image filename ?    ppm-format, size "); 
  WriteInt(size, 3);  WriteString("x"); WriteInt(size, 3); WriteLn;
  ReadString(inputFilename);

  read_c_image(col_image, inputFilename, width, height);  
  
  bin_image := gray2binary(color2gray(col_image), 127);

  WriteString("thin_StefRosen"); WriteLn;
  thin_image := thin_StefRosen(bin_image);
  write_b_image (thin_image, "res_StefRosen.pbm", size, size);

  WriteString("thin_LueWang"); WriteLn;
  thin_image := thin_LueWang(bin_image);
  write_b_image (thin_image, "res_LueWang.pbm", size, size);

  WriteString("thin_HallGuo"); WriteLn;
  thin_image := thin_HallGuo(bin_image);
  write_b_image (thin_image, "res_HallGuo.pbm", size, size);

END check_thin.

