MODULE edge;
FROM ImageIO  IMPORT read_c_image,  read_g_image,  read_b_image,
                     write_c_image, write_g_image, write_b_image,
                     color, gray, binary;

CONFIGURATION grid[0..127],[0..127];
CONNECTION up  : grid[i,j] <-> grid[i+1,j] :down;
           left: grid[i,j] <-> grid[i,j-1] :right;

  PROCEDURE laplace_3x3(x: grid OF gray) : grid OF INTEGER;
  (* 0 -1  0
    -1  4 -1
     0 -1  0 *)  
  BEGIN
    RETURN 4*x - MOVE.up(x) - MOVE.down(x) - MOVE.left(x) - MOVE.right(x);
  END laplace_3x3;

  PROCEDURE int2gray (in: grid OF INTEGER): grid OF gray;
  VAR tmax,tmin: INTEGER;
  BEGIN
    tmin := REDUCE.MIN(in);
    tmax := REDUCE.MAX(in);
    RETURN 255 * (in - tmin) DIV (tmax-tmin+1);
  END int2gray;

(* ***************************** *)

VAR c           : grid OF color;
    g           : grid OF gray;
    b           : grid OF binary;
    i           : grid OF INTEGER;
    width,height: CARDINAL;

BEGIN
  read_c_image(c,"test.ppm",width,height);
  WriteString("laplace"); WriteLn;
  i := laplace_3x3(c.green);
  WriteString("int2gray"); WriteLn;
  g := int2gray(i);
  write_g_image(g, "out.pgm",width,height);
  b := (c.red+c.green+c.blue) DIV 3 > 100;
  write_b_image(b, "out.pbm",width,height);
END edge.

