IMPLEMENTATION MODULE complex_arithmetic;

(* ---------------------------------------------------------------------------- *)
(* Projekt:  Studienarbeit Transformationen fuer die parallele Bild-		*)
(*           verarbeitung							*)
(* Funktion: Stellt Arithemetikoperationen fuer komplexe Zahlen zur Verfuegung.	*)
(* System:   SunOS 4.1.3							*)
(* Sprache:  Parallaxis III							*)
(* Autor:    Stefan Feyrer							*)
(* Beginn:   08.01.1994								*)
(* Stand:    10.02.1995								*)
(* ---------------------------------------------------------------------------- *)

(* ---------------------------------------------------------------------------- *)
	  (* Liefert die Betraege von komplexen Zahlen.				*)
	  (* ------------------------------------------------------------------ *)

PROCEDURE complex_abs (c: VECTOR OF complex): VECTOR OF REAL;

  BEGIN (* complex_abs *)

    RETURN sqrt (c.re**2.0 + c.im**2.0);

  END complex_abs;

(* ---------------------------------------------------------------------------- *)
	  (* Liefert die Summe von komplexen Zahlen.				*)
	  (* ------------------------------------------------------------------ *)

PROCEDURE complex_add (a, b: VECTOR OF complex): VECTOR OF complex;

  VAR result: VECTOR OF complex;

  BEGIN (* complex_add *)

    result.re := a.re + b.re;
    result.im := a.im + b.im;
    RETURN result;

  END complex_add;

(* ---------------------------------------------------------------------------- *)
	  (* Liefert die Differenz von komplexen Zahlen.			*)
	  (* ------------------------------------------------------------------ *)

PROCEDURE complex_sub (a, b: VECTOR OF complex): VECTOR OF complex;

  VAR result: VECTOR OF complex;

  BEGIN (* complex_sub *)

    result.re := a.re - b.re;
    result.im := a.im - b.im;
    RETURN result;

  END complex_sub;

(* ---------------------------------------------------------------------------- *)
	  (* Liefert die Differenz von komplexen Zahlen.			*)
	  (* ------------------------------------------------------------------ *)

PROCEDURE complex_mult (a, b: VECTOR OF complex): VECTOR OF complex;

  VAR result: VECTOR OF complex;

  BEGIN (* complex_mult *)

    result.re := a.re * b.re - a.im * b.im;
    result.im := a.im * b.re + a.re * b.im;
    RETURN result;

  END complex_mult;

(* ---------------------------------------------------------------------------- *)

END complex_arithmetic.






