MODULE ft;

(* ---------------------------------------------------------------------------- *)
(* Projekt:  Studienarbeit Parallele Bildtransformationen			*)
(* Funktion: Berechnet das Fourier-Spektrum eines Graustufenbildes in den	*)
(*	     verschiedenen Variationen.						*)
(* System:   SunOS 4.1.3							*)
(* Sprache:  Parallaxis III							*)
(* Autor:    Stefan Feyrer							*)
(* Beginn:   13.09.1994								*)
(* Stand:    28.12.1994								*)
(* ---------------------------------------------------------------------------- *)

FROM Local             IMPORT grid;
FROM ImageIO           IMPORT gray, read_g_image, write_g_image;
FROM fourier_transform IMPORT fourier_spectrum;

(* ---------------------------------------------------------------------------- *)

CONST max_height = 256;
      max_width  = 256;

(* ---------------------------------------------------------------------------- *)

CONFIGURATION my_grid = grid [1..max_height],[1..max_width];

(* ---------------------------------------------------------------------------- *)

TYPE my_image = my_grid OF gray;
     string   = ARRAY [1..100] OF CHAR;
     
(* ---------------------------------------------------------------------------- *)

VAR in_file, out_file: string;
    v, s:              my_image;
    width, height:     CARDINAL;
    centered:          INTEGER;
    log_scale:         INTEGER;

(* ---------------------------------------------------------------------------- *)
 
BEGIN (* ft *)

  WriteString ("Fourier-Transformation");
  WriteLn;

  WriteString ("Zu bearbeitende Bilddatei (Graustufenbild): ");
  ReadString (in_file);
  read_g_image (v, in_file, width, height);

  WriteString ("Spektrum zentrieren? (0 = nein, sonst ja) ");
  ReadInt (centered);
  WriteString ("Spektrum logarithmisch? (0 = nein, sonst ja) ");
  ReadInt (log_scale);

  s := fourier_spectrum (v, width, height, centered#0, log_scale#0);

  WriteString ("Ergebnisbild ablegen in: ");
  ReadString (out_file);
  write_g_image (s, out_file, width, height);

END ft.


