MODULE ht;

(* ---------------------------------------------------------------------------- *)
(* Projekt:  Studienarbeit Parallele Bildtransformationen			*)
(* Funktion: Wendet die Hough-Transformation auf Binaerbilder an.		*)
(* System:   SunOS 4.1.3							*)
(* Sprache:  Parallaxis III							*)
(* Autor:    Stefan Feyrer							*)
(* Beginn:   13.09.1994								*)
(* Stand:    11.02.1995								*)
(* ---------------------------------------------------------------------------- *)

FROM Local           IMPORT grid;
FROM ImageIO         IMPORT read_b_image, write_b_image, binary;
FROM hough_transform IMPORT hough_trans, line_list_type, draw_lines,
                            extract_lines, free_list;

(* ---------------------------------------------------------------------------- *)

CONST max_height = 64;
      max_width  = 64;

(* ---------------------------------------------------------------------------- *)

CONFIGURATION my_grid = grid [1..max_height],[1..max_width];

(* ---------------------------------------------------------------------------- *)

TYPE my_image = my_grid OF binary;
     string   = ARRAY [1..100] OF CHAR;

(* ---------------------------------------------------------------------------- *)

VAR in_file, out_file: string;
    v:                 my_image;
    width, height:     CARDINAL;
    lines:             line_list_type;
    num_lines:         INTEGER;
    line_image:        my_image;
    result_image:      my_image;
    max_size:          CARDINAL;

(* ---------------------------------------------------------------------------- *)
	  (* Liefert das Maximum zweier Zahlen.					*)
	  (* ------------------------------------------------------------------ *)

PROCEDURE maximum (a, b: CARDINAL): CARDINAL;

  BEGIN (* maximum *)

    IF a < b THEN
      RETURN b;
    ELSE
      RETURN a;
    END; (* IF *)

  END maximum;

(* ---------------------------------------------------------------------------- *)

BEGIN (* ht *)

  WriteString ("Hough-Transformation");
  WriteLn;

  WriteString ("Zu bearbeitende Bilddatei (schwarz/weiss): ");
  ReadString (in_file);
  read_b_image (v, in_file, width, height);

  WriteString ("Wieviele Geraden sollen extrahiert werden? ");
  ReadInt (num_lines);

  max_size := maximum (width, height);

  lines := hough_trans (v, width, height, max_size, num_lines);

  draw_lines (line_image, width, height, lines);
  extract_lines (result_image, v, width, height, lines);

  free_list (lines);

  WriteString ("Geradenbild ablegen in: ");
  ReadString (out_file);
  write_b_image (line_image, out_file, width, height);

  WriteString ("Ergebnisbild ablegen in: ");
  ReadString (out_file);
  write_b_image (result_image, out_file, width, height);

END ht.


