MODULE kt;

(* ---------------------------------------------------------------------------- *)
(* Projekt:  Studienarbeit Parallele Bildtransformationen			*)
(* Funktion: Berechnet das KL-transformierte Bild eines Binaerbildes.		*)
(* System:   SunOS 4.1.3							*)
(* Sprache:  Parallaxis III							*)
(* Autor:    Stefan Feyrer							*)
(* Beginn:   13.09.1994								*)
(* Stand:    28.12.1994								*)
(* ---------------------------------------------------------------------------- *)

FROM Local        IMPORT grid;
FROM ImageIO      IMPORT read_b_image, write_b_image, binary;
FROM kl_transform IMPORT kl_trans;

(* ---------------------------------------------------------------------------- *)

CONST max_height = 128;
      max_width  = 128;

(* ---------------------------------------------------------------------------- *)

CONFIGURATION my_grid = grid [1..max_height],[1..max_width];

(* ---------------------------------------------------------------------------- *)

TYPE my_image = my_grid OF binary;
     string   = ARRAY [1..100] OF CHAR;

(* ---------------------------------------------------------------------------- *)

VAR in_file, out_file: string;
    v:                 my_image;
    width, height:     CARDINAL;

(* ---------------------------------------------------------------------------- *)

BEGIN (* kt *)

  WriteString ("KL-Transformation");
  WriteLn;

  WriteString ("Zu bearbeitende Bilddatei (schwarz/weiss): ");
  ReadString (in_file);
  read_b_image (v, in_file, width, height);

  v := kl_trans (v, width, height);

  WriteString ("Ergebnisbild ablegen in: ");
  ReadString (out_file);
  write_b_image (v, out_file, width, height);

END kt.


