MODULE tt;

(* ---------------------------------------------------------------------------- *)
(* Projekt:  Studienarbeit Parallele Bildtransformationen			*)
(* Funktion: Berechnet die Koeffizienten einer Textur.				*)
(* System:   SunOS 4.1.3							*)
(* Sprache:  Parallaxis III							*)
(* Autor:    Stefan Feyrer							*)
(* Beginn:   13.09.1994								*)
(* Stand:    10.02.1995								*)
(* ---------------------------------------------------------------------------- *)

FROM Local    IMPORT grid;
FROM ImageIO  IMPORT gray, read_g_image, write_g_image;
FROM textures IMPORT direction_type, co_occ_grid, co_occur, feature_energy,
                     feature_entropy, feature_correlation, feature_inertia,
                     feature_local_homogeneity;

(* ---------------------------------------------------------------------------- *)

CONST max_height = 16;
      max_width  = 16;

(* ---------------------------------------------------------------------------- *)

CONFIGURATION my_grid = grid [1..max_height],[1..max_width];

(* ---------------------------------------------------------------------------- *)

TYPE my_image = my_grid OF gray;
     string   = ARRAY [1..100] OF CHAR;
     
(* ---------------------------------------------------------------------------- *)

VAR file:          string;
    v:             my_image;
    c:             co_occ_grid OF REAL;
    width, height: CARDINAL;
   
BEGIN (* tt *)

  WriteString ("Texturen");
  WriteLn;

  WriteString ("Zu bearbeitende Bilddatei (Graustufenbild): ");
  ReadString (file);
  read_g_image (v, file, width, height);
  WriteString ("horizontal:"); WriteLn;

  c := co_occur (v, width, height, horizontal);

  WriteString ("Energie:             ");
  WriteReal (feature_energy (c), 15);
  WriteLn;
  WriteString ("Entropie:            ");
  WriteReal (feature_entropy (c), 15);
  WriteLn;
  WriteString ("Korrelation:         ");
  WriteReal (feature_correlation (c), 15);
  WriteLn;
  WriteString ("Traegheit:           ");
  WriteReal (feature_inertia (c), 15);
  WriteLn;
  WriteString ("Lokale Homogenitaet: ");
  WriteReal (feature_local_homogeneity (c), 15);
  WriteLn;

END tt.


