MODULE rainbow;
FROM Graphics IMPORT OpenWindow, SelectWindow, CloseWindow,
                     SetLine, window;
FROM ImageIO IMPORT  color;
FROM Trans   IMPORT  gray2rainbow;

CONST 
 max_width   = 256;     (* maximum image width  *)
 max_height  =  20;     (* maximum image height *)

CONFIGURATION list[0..255];

VAR c  : CHAR;
    w1 : window;
    i  : INTEGER;
    pos: list OF CARDINAL;
    col: list OF color;

BEGIN
  w1:= OpenWindow("Parallaxis Rainbow", max_width, max_height);
  pos := DIM(list,1) DIV 2 * 2;  (* use less color values *)
  col := gray2rainbow(pos);

  FOR i:= 0 TO 19 DO
    SetLine(col, i);
  END;

  WriteString("press RETURN to terminate"); WriteLn;
  Read(c);
  CloseWindow(w1);
END rainbow.

