MODULE xauto;
FROM Graphics IMPORT OpenWindow,CloseWindow,SetbLineZ,window;

CONST n    = 256;          (* number of elements *)
      m    = (n+1) DIV 2;  (* number of loops    *)
      zoom =   2;

CONFIGURATION list [1..n];
CONNECTION left:  list[i] -> list[i-1];
           right: list[i] -> list[i+1];
 
VAR line: INTEGER;
    win : window;
    ch  : CHAR;
    val : list OF BOOLEAN;
 
BEGIN
  win := OpenWindow("xauto", zoom*n,zoom*m);
  val := ID(list) = m; (* Init *)

  FOR line:= 0 TO m-1 DO
    SetbLineZ(val,zoom*line, 0, zoom);
    val := MOVE.left(val) <> MOVE.right(val);
  END;

  WriteString("Press RETURN for termination"); WriteLn;
  Read(ch);
  CloseWindow(win);
END xauto.

