MODULE xfractal;
FROM Graphics IMPORT OpenWindow,CloseWindow,Line,SetPixel,window;

CONST  maxlevel  =  8;
       low_val   = 0.0;
       high_val  = 1.0;
       maxnode   = 2**maxlevel - 1;
       leaf_end  = maxnode;
       leaf_start= (leaf_end+1) DIV 2;
       leaf_num  = leaf_start;
       zoom      = 3;
       height    = zoom * maxnode DIV 3;

CONFIGURATION tree [1..maxnode];
CONNECTION    child_l: tree[i] <-> tree[2*i]   :parent;
              child_r: tree[i] <-> tree[2*i+1] :parent;

VAR  i,zero,xpos     : CARDINAL;
     win             : window;
     delta,xmax,xmin : REAL;
     ch              : CHAR;
     field1,field2   : ARRAY [1..maxnode] OF INTEGER; 
     x, low, high    : tree OF REAL;
     pos             : tree OF CARDINAL;

PROCEDURE Gauss(): tree OF REAL;
(* random number with Gaussian distribution *)
CONST N  = 4;
      GA = (FLOAT(3*N)) ** 0.5;
      GF = 2.0*GA / (FLOAT(N)*FLOAT(MAX(INTEGER)));
VAR i  : INTEGER; 
    sum: tree OF REAL;
BEGIN
  sum:=0.0;
  FOR i:=1 TO N DO sum:= sum + FLOAT(ABS(RandomInt(tree))) END;
  RETURN (GF*sum - GA)
END Gauss;

PROCEDURE inorder(node: INTEGER);
BEGIN
  IF node <= maxnode THEN
    inorder(2*node);
      (* SetPixel(xpos, field[node]); *)
      field2[xpos] := field1[node];
      INC(xpos);
    inorder(2*node+1);
  END
END inorder;

PROCEDURE MidPoint(delta: REAL; level: INTEGER);
BEGIN
  IF 2**(level-1) <= ID(tree) <=  2**level - 1 THEN (* select tree level *)
    x := 0.5 * (low + high) + delta*Gauss();
    IF level < maxlevel THEN
      SEND.child_l(low,low); (* values for children *)
      SEND.child_l(x,high);
      SEND.child_r(x,low);
      SEND.child_r(high,high);
    END;
  END;
END MidPoint;

BEGIN (* main *)
  low  := low_val;   (* starting values *)
  high := high_val;
  x    := 0.0;
  FOR i:=1 TO maxlevel DO
    delta := 0.5 ** (FLOAT(i)/2.0);
    MidPoint(delta,i);  (* changes global x *)
  END;
  xmin := REDUCE.MIN(x);
  xmax := REDUCE.MAX(x);
  IF xmin=xmax THEN xmax := xmax+1.0 END;  (* avoid div. by 0 *)

  win  := OpenWindow("xfractal", zoom*maxnode, height); 
  IF xmin < 0.0 THEN  (* mark zero level *)
    zero := height - TRUNC(FLOAT(height)*(-xmin)/(xmax-xmin));
    Line(0,zero, zoom*maxnode-1,zero)
  END;
  pos  := height - TRUNC(FLOAT(height)*(x-xmin)/(xmax-xmin));
  STORE(pos,field1); 
  xpos := 1;
  inorder(1);  (* sort field1 into field2 *)

  FOR xpos := 1 TO maxnode DO
    Line(zoom*xpos-1,field2[xpos], zoom*(xpos+1)-1,field2[xpos+1]);
  END;

  WriteString("Press RETURN for termination"); WriteLn;
  Read(ch);
  CloseWindow(win);
END xfractal.

