MODULE xlife;
FROM Graphics IMPORT OpenWindow, CloseWindow, SetbAreaXYZ, window;

CONST ny       = 64;
      nx       = 64;
      max_iter =  5;
      zoom     =  4;

CONFIGURATION field [0..ny-1],[0..nx-1];
CONNECTION    l_r: field[i,j] -> field[(i-1) MOD ny, j],
                                 field[(i+1) MOD ny, j];
              u_d: field[i,j] -> field[i, (j+1) MOD nx],
                                 field[i, (j-1) MOD nx];

VAR win                : window;
    i                  : INTEGER;
    val                : field OF BOOLEAN;
    buf,anz,anzlr,abuf : field OF INTEGER;

BEGIN
   win := OpenWindow("xlife", nx*zoom, ny*zoom);
   val := RandomBool(field);
   FOR i:=1 TO max_iter DO
     SEND.l_r:#SUM (ORD(val),buf);
     anzlr := ORD(val) + buf;
     SEND.u_d:#SUM (anzlr,abuf);
     anz := anzlr + abuf;
     IF val THEN
       IF (anz < 3) OR (anz > 4) THEN val := FALSE END
      ELSIF anz = 3 THEN val := TRUE
     END; (* if *)
     SetbAreaXYZ(val,0,0,zoom);
   END; (* for *)
   CloseWindow(win);
END xlife.

