MODULE xmandel;
(* Iterative Computation of Mandelbrot Set    *)
(* With X Window Visualization,  Braunl, 1994 *)
FROM Graphics IMPORT OpenWindow,CloseWindow,SetgAreaXYZ,window;
FROM ImageIO  IMPORT gray, g_white;

CONST n        =   64;
      max_iter =    6;
      s_dec    =   255 DIV max_iter;
      north    =   1.3;  south = -1.3;
      west     =  -2.0;  east  =  0.6;
      zoom     =     2;

TYPE  complex  = RECORD re,im: REAL
                 END;

CONFIGURATION grid[0..n-1],[0..n-1];

VAR win   : window;
    shade : INTEGER;
    ch    : CHAR;
    c, z  : grid OF complex;

PROCEDURE C_Add (a,b: grid OF complex): grid OF complex;
VAR res: grid OF complex;
BEGIN
  res.re := a.re + b.re;
  res.im := a.im + b.im;
  RETURN(res);
END C_Add;

PROCEDURE C_Mul (a,b: grid OF complex): grid OF complex;
VAR res: grid OF complex;
BEGIN
  res.re := a.re*b.re - a.im*b.im;
  res.im := a.re*b.im + a.im*b.re;
  RETURN(res);
END C_Mul;

PROCEDURE C_Abs2 (a: grid OF complex) : grid OF REAL;
BEGIN (* returns square of length of a complex number *)
  RETURN a.re*a.re + a.im*a.im;
END C_Abs2;

BEGIN
  win := OpenWindow("xmandel", n*zoom, n*zoom);
  (* compute real and imaginary parts *)
  c.re := west  + FLOAT(DIM(grid,1)) * (east -west )/FLOAT(n-1);
  c.im := south + FLOAT(DIM(grid,2)) * (north-south)/FLOAT(n-1);
  z:=c;
  shade := g_white;

  WHILE (shade > 0) AND (C_Abs2(z) < 5.0) DO
    z   := C_Add( C_Mul(z,z), c );
    SetgAreaXYZ(grid(shade),0,0,zoom);  (* fill remaining region *)
    DEC(shade,s_dec);
  END;

  WriteString("Press RETURN for termination"); WriteLn;
  Read(ch);
  CloseWindow(win);
END xmandel.

