MODULE xprime;
(* X window visualization of prime sieve, Braunl 1992 *)
FROM Graphics IMPORT OpenWindow,CloseWindow,SetbLineZ,window;

CONST n    = 400;
      zoom =   2;
CONFIGURATION list [2..n];
CONNECTION  (* none *);

VAR prime, step: INTEGER;
    win        : window;
    ch         : CHAR;
    removed    : list OF BOOLEAN;

BEGIN
  win  := OpenWindow("xprime", zoom*n, zoom*n DIV 3); 
  step := 0;

  REPEAT
    prime:= REDUCE.FIRST(DIM(list,1));
     removed := DIM(list,1) MOD prime = 0; (* remove multiples *)
    INC(step);
    SetbLineZ(NOT removed, zoom*step, 0,zoom);
  UNTIL removed;

  WriteString("Press RETURN for termination"); WriteLn;
  Read(ch);
  CloseWindow(win);
END xprime.

